﻿#include <fmp_manager_i.h>
#include <QDebug>
#include <QPluginLoader>
#include <QSettings>
#include <QDir>
#include <QDirIterator>
#include <qtservice.h>

#ifdef Q_OS_WIN
#include <Windows.h>

//! 命名冲突
#undef StartService
#endif

#include "../application/fm_singleton.h"
#include "../fmp_settings/fmp_settings_def.h"

class FMPAppService : public QtService<FMSingleApplication>
{
public:
    FMPAppService(int argc, char**argv, const QString &svcname) :
        _starttype(0),
        _name(svcname),
        _setting(0),
        QtService<FMSingleApplication>(argc, argv, svcname)
    {
        createApplication(argc, argv);
        _setting = new QSettings(qApp->applicationDirPath() + "/" + qApp->applicationName() + ".ini", QSettings::IniFormat);
        _starttype = _setting->value(FMP_INIKEY_SERVICESTARTTYPE, 0).toInt();
        _description = _setting->value(FMP_INIKEY_SERVICEDESC, "Freemud POS plugin service").toString();

        setStartupType((QtServiceController::StartupType)_starttype);
        setServiceDescription(_description);
    }

    bool        isRunning()
    {
        return application()->IsRunning();
    }

    void        start()
    {
        FMPManager fmpManager = FMP::GetManager();
        fmpManager->StartService();
    }

protected:
    virtual void createApplication(int &argc, char **argv)
    {
        if (!application()) {
            QtService::createApplication(argc, argv);
        }
    }
private:
    int         _starttype;
    QSettings  *_setting;

    QString     _name;
    QString     _description;
};

#define SERVICE 0

int main(int argc, char** argv)
{
    QString app_path = QString::fromLocal8Bit(argv[0]);
    app_path.replace("\\", "/");
    QString app_dir = app_path.section("/", 0, -2);
    QString app_name = app_path.section("/", -1);
    QSettings setting(app_dir + "/" + app_name.replace(".exe", ".ini"), QSettings::IniFormat);
    QString svc_name = setting.value(FMP_INIKEY_SERVICENAME, "FMPService").toString();

    FMPAppService svc(argc, argv, svc_name);

    if (!svc.isRunning()) {
#if SERVICE
        return svc->exec();
#else
        svc.start();
        return qApp->exec();
#endif
    }
    else {
        return 0;
    }
}
