#include "refdishesForm.h"
#include "ui_refdishesForm.h"
#include "Control/flowControl.h"

refDishesForm::refDishesForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::refDishesForm)
{
    ui->setupUi(this);

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

    connect(this, &refDishesForm::updDishes, &FlowControl::GetInstance(), &FlowControl::onUpdDishesForRef);
}

refDishesForm::~refDishesForm()
{
    delete ui;
}

void refDishesForm::InitData(OrderObject *obj)
{
    //  清除之前的菜品按钮信息
    _Init();

    int i=0;
    foreach (ProductObject *product, obj->proList)
    {
        QPushButton *btn = new QPushButton(this);
        btn->setFixedSize(260, 50);
        btn->setCheckable(true);
        btn->setText(product->name);
        btn->setObjectName(product->pid);
        btn->setStyleSheet("QPushButton{    color: #3d3d3d;      \
                                                                        background-color: rgb(255, 255, 255);       \
                                                                        border: 1px solid #C0C0C0;  \
                                                                        border-radius: 3px;}         \
                                            QPushButton:checked     \
                                            {   \
                                                color: rgb(24, 206, 0);       \
                                                background-color: rgb(255, 255, 255);     \
                                                border-radius: 3px;       \
                                                border: 1px solid rgb(24, 206, 0);  \
                                             }");
        if(i<6)
        {
            ui->verticalLayout_left->insertWidget(0, btn);
        }else
        {
            ui->verticalLayout_right->insertWidget(0, btn);
        }

        connect(btn, &QPushButton::toggled, this, &refDishesForm::onDishesBtnToggled);

        m_btnList.append(btn);
        i++;
    }
}

void refDishesForm::_Init()
{
    ui->refDishesBtnOk->setEnabled(false);
    foreach(QPushButton* btn, m_btnList)
    {
        disconnect(btn, &QPushButton::toggled, this, &refDishesForm::onDishesBtnToggled);
        delete btn;
    }
    m_btnList.clear();
    m_dishesMap.clear();
}

void refDishesForm::on_refDishesBtnOk_clicked()
{
    emit updDishes("" ,m_dishesMap);
    accept();
}

void refDishesForm::on_refDishesBtnCancle_clicked()
{
    reject();
}

void refDishesForm::onDishesBtnToggled(bool checked)
{
    QPushButton* btn = (QPushButton*)sender();
    if(checked)
    {
        m_dishesMap.insert(btn->objectName(), 0);
    }else
    {
        m_dishesMap.remove(btn->objectName());
    }
    if(m_dishesMap.count() > 0)
    {
        ui->refDishesBtnOk->setEnabled(true);
    }else
    {
        ui->refDishesBtnOk->setEnabled(false);
    }
}
