#include "dishesItem.h"
#include "ui_dishesItem.h"
#include <QDebug>
#include "Control/flowControl.h"
#include <dishesForm.h>

dishesItem::dishesItem(dishesObject dishesObj, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dishesItem)
{
    ui->setupUi(this);
    ui->disItemLabSku->hide();

    Init(dishesObj);

    setAttribute(Qt::WA_TranslucentBackground);

    connect(&FlowControl::GetInstance(), &FlowControl::processDishiesSuccssful, this, &dishesItem::onUpdDishesFinsh);


    m_pickForm = new DishesPickForm((QWidget*)this->parent()->parent());
}

dishesItem::~dishesItem()
{
    delete ui;
}

void dishesItem::Init(dishesObject dishesObj)
{
    m_dishesObj = dishesObj;

    ui->disItemLabName->setText(m_dishesObj.name);

    QString text;
    bool bFirst = true;
    foreach(QString channelNameCode, dishesObj.channelCode_status.keys())
    {
        if( bFirst )
        {
            bFirst = false;
        }else
        {
            text.append(", ");
        }

        text.append(QString("<font color='%1'>%2</font>")
                    .arg(dishesObj.channelCode_status.value(channelNameCode) == 0? "#ff0000" : "#55aa00")
                    .arg(channelNameCode.split(":").at(0)) );
    }
    ui->disItemLabStatus->setText(text);
}

void dishesItem::on_disItemBtn_clicked()
{
    m_pickForm->Init(m_dishesObj.code, m_dishesObj.channelCode_status);
    m_pickForm->show();
}

void dishesItem::onUpdDishesFinsh(QStringList channels, QString dishesId, int status)
{
    if(dishesId == m_dishesObj.code)
    {
        foreach (QString channel, channels) {
            m_dishesObj.channelCode_status.insert(channel, status);
        }


        QString text;
        bool bFirst = true;
        foreach(QString channelNameCode, m_dishesObj.channelCode_status.keys())
        {
            if( bFirst )
            {
                bFirst = false;
            }else
            {
                text.append(", ");
            }

            text.append(QString("<font color='%1'>%2</font>")
                        .arg(m_dishesObj.channelCode_status.value(channelNameCode) == 0? "#ff0000" : "#55aa00")
                        .arg(channelNameCode.split(":").at(0)) );
        }
        ui->disItemLabStatus->setText(text);

    }

}
