#include "dishesForm.h"
#include "ui_dishesForm.h"
#include <QPushButton>
#include "Control/flowControl.h"
#include <QDebug>
#include <QMapIterator>
#include "disTabWdg.h"

dishesForm::dishesForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::dishesForm)
{
    ui->setupUi(this);

    connect(&FlowControl::GetInstance(), &FlowControl::iniDishesData, this, &dishesForm::IniDishesData);

    m_pickForm = new DishesPickForm(this);


    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

}

dishesForm::~dishesForm()
{
    delete ui;
}

void dishesForm::IniDishesData(QMap<QString, QMap<QString, dishesObject> > dishesMap)
{
    // 清除TabWidget中的Tab
    ui->channelTabWdg->clear();
    // 清除TabWidget中的Widget控件
    foreach(disTabWdg *pTabWdg, m_tabWdgList)
    {
        delete pTabWdg;
    }
    m_tabWdgList.clear();



    // 初始化TabWidget
    // 遍历各渠道
    foreach(QString categoryName, dishesMap.keys())
    {
        disTabWdg *pTabWdg = new disTabWdg(this);
        m_tabWdgList.append(pTabWdg);
        connect(pTabWdg, &disTabWdg::doHide, this, &dishesForm::hide);
        pTabWdg->IniDishesData(dishesMap.value(categoryName));
        ui->channelTabWdg->addTab(pTabWdg, categoryName);
    }

    this->show();
}
