#include "dailyform.h"
#include "ui_dailyform.h"
#include "fmPrinter.h"
#include "DTools/configManger.h"

DailyForm::DailyForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DailyForm)
{
    ui->setupUi(this);

    connect(&FlowControl::GetInstance(), &FlowControl::showDailyStatement, this, &DailyForm::onShowDailyForm);

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    this->setModal(true);

    m_map.insert("mtwm", "美团外卖");
    m_map.insert("bdwm", "百度外卖");
    m_map.insert("jdwm", "京东到家");
    m_map.insert("eleme2", "饿了么  ");
    m_map.insert("fmwd", "非码微店");
    m_map.insert("mall", "APP ");

    ui->daily_table0->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->daily_table0->horizontalHeader()->setSectionResizeMode(2, QHeaderView::ResizeToContents);

    ui->daily_table1->horizontalHeader()->setSectionResizeMode(QHeaderView::Stretch);
    ui->daily_table1->horizontalHeader()->setSectionResizeMode(2, QHeaderView::ResizeToContents);
}

DailyForm::~DailyForm()
{
    delete ui;
}


void DailyForm::onShowDailyForm(QList<DailyStatement> infos)
{
    m_printDate = "";
    ui->daily_table0->clearContents();
    ui->daily_table0->setRowCount(0);
    ui->daily_table1->clearContents();
    ui->daily_table1->setRowCount(0);

    QDateTime time = QDateTime::currentDateTime();

    ui->daily_labStoreName->setText(FlowControl::GetInstance().storeName());
    ui->daily_labStoreNum->setText(FlowControl::GetInstance().storeId());

    ui->daily_labDateHead->setText(time.toString("yyyy-MM-dd"));
    ui->daily_labDate->setText(QString("00:00:00 - %1").arg(time.toString("hh:mm:ss")));

    int shop_total_fee = 0;



    QString tmp_printDate0(""), tmp_printDate1("");
    foreach (DailyStatement info, infos) {
        ui->daily_table0->insertRow(0);
        QTableWidgetItem *channel0 = new QTableWidgetItem(m_map.value(info.channel));
        channel0->setTextAlignment(Qt::AlignCenter);
        ui->daily_table0->setItem(0, 0, channel0);
        QTableWidgetItem *num0 = new QTableWidgetItem(QString::number(info.total_number));
        num0->setTextAlignment(Qt::AlignCenter);
        ui->daily_table0->setItem(0, 1, num0);
        QTableWidgetItem *fee0 = new QTableWidgetItem(QString::number((float)(info.product_fee_zps+info.product_fee-info.discount_shop_fee-info.discount_shop_fee_zps)/100, 'f' , 1));
        fee0->setTextAlignment(Qt::AlignCenter);
        ui->daily_table0->setItem(0, 2, fee0);
        tmp_printDate0.append(QString("%1*X%2*%3").arg(m_map.value(info.channel)).arg(info.total_number).arg(QString::number((float)(info.product_fee_zps+info.product_fee-info.discount_shop_fee-info.discount_shop_fee_zps)/100, 'f' , 1)));
        tmp_printDate0.append("$");

        ui->daily_table1->insertRow(0);
        QTableWidgetItem *channel1 = new QTableWidgetItem(m_map.value(info.channel));
        channel1->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 0, channel1);
        QTableWidgetItem *num1 = new QTableWidgetItem(QString("自配送"));
        num1->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 1, num1);
        QTableWidgetItem *fee1 = new QTableWidgetItem(QString::number((float)info.send_fee_zps/100, 'f' , 1));
        fee1->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 2, fee1);
        tmp_printDate1.append(QString("%1*自配送*%3").arg(m_map.value(info.channel)).arg(QString::number((float)info.send_fee_zps/100, 'f' , 1)));
        tmp_printDate1.append("$");

        ui->daily_table1->insertRow(0);
        QTableWidgetItem *channel2 = new QTableWidgetItem(m_map.value(info.channel));
        channel2->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 0, channel2);
        QTableWidgetItem *num2 = new QTableWidgetItem(QString("平台配送"));
        num2->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 1, num2);
        QTableWidgetItem *fee2 = new QTableWidgetItem(QString::number((float)info.send_fee/100, 'f' , 1));
        fee2->setTextAlignment(Qt::AlignCenter);
        ui->daily_table1->setItem(0, 2, fee2);
        tmp_printDate1.append(QString("%1*平台配送*%3").arg(m_map.value(info.channel)).arg(QString::number((float)info.send_fee/100, 'f' , 1)));
        tmp_printDate1.append("$");

        shop_total_fee += info.product_fee_zps+info.product_fee-info.discount_shop_fee-info.discount_shop_fee_zps;
    }




//    tmp_printDate0.append(QString("%1*X%2*%3").arg("总计    ").arg(channel0_total_num).arg(QString::number((float)channel0_total_fee/100, 'f' , 2)));

//    tmp_printDate1.append(QString("%1*X%2*%3").arg("总计    ").arg(channel1_total_num).arg(QString::number((float)channel1_total_fee/100, 'f' , 2)));


    ui->daily_labTotalFee->setText(QString::number((float)shop_total_fee/100, 'f' , 1));

    m_printDate.append(QString("门店号: %1").arg(FlowControl::GetInstance().storeId()));
    m_printDate.append("|");
    m_printDate.append(QString("时间: %1").arg(time.toString("yy-MM-dd hh:mm")));
    m_printDate.append("|");
    m_printDate.append(tmp_printDate0);
    m_printDate.append("|");
    m_printDate.append(tmp_printDate1);
    m_printDate.append("|");
    m_printDate.append(QString("商品总金额:  %1").arg(QString::number((float)shop_total_fee/100, 'f' , 1)));
    m_printDate.append("|1");

    show();
}

void DailyForm::on_daily_btnClose_clicked()
{
    hide();
}

void DailyForm::on_daily_btnPrint_clicked()
{
    FmPrinter::GetInstance().TestPrint(ConfigManger::GetInstance().GetPrinterName(), m_printDate);
}
