#include "bstatusForm.h"
#include "ui_bstatusForm.h"
#include "Control/flowControl.h"
#include "bstatusItem.h"

BStatusForm::BStatusForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BStatusForm)
{
    ui->setupUi(this);

    connect(&FlowControl::GetInstance(), &FlowControl::initChannelsData, this, &BStatusForm::onInitChannelsData);

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);
}

BStatusForm::~BStatusForm()
{
    delete ui;
}

void BStatusForm::onInitChannelsData(QStringList list)
{
    foreach(BStatusItem* item, m_items)
    {
        delete item;
    }
    m_items.clear();

    foreach(QString channelInfo, list)
    {
        BStatusItem *item = new BStatusItem(this);
        item->InitData(channelInfo);
        m_items.append(item);
        ui->verticalLayout->insertWidget(0, item);
    }

    show();
}

void BStatusForm::on_btsBtnClose_clicked()
{
    hide();
}
