#include "orderObject.h"
#include "preDefine.h"
#include <QJsonArray>
#include <QJsonDocument>

void OrderObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(proList);
    proList.clear();
    FetchDataFromJson(json);
    QJsonArray products = json[JSON_PRODUCTS].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        ProductObject *proObject = new ProductObject(this);
        proObject->FetchDataFromJson(proJson);
        proList.append(proObject);
    }

    return;
}

QString OrderObject::toString()
{
    QJsonObject json;
    const QMetaObject *meta = metaObject();
    for( int i=meta->propertyOffset(); i<meta->propertyCount(); i++ )
    {
        json.insert( meta->property(i).name(),
                    QJsonValue::fromVariant(property(meta->property(i).name())) );

    }

    return QString(QJsonDocument(json).toJson().simplified());
}

int OrderObject::getpackage_fee() const
{
    return package_fee;
}

void OrderObject::setpackage_fee(const int &v)
{
    package_fee= v;
}

int OrderObject::getorder_type() const
{
    return order_type;
}

void OrderObject::setorder_type(const int &v)
{
    order_type = v;
}

QString OrderObject::getorder_view_id() const
{
    return order_view_id;
}

void OrderObject::setorder_view_id(const QString &v)
{
    order_view_id = v;
}

int OrderObject::getstatus() const
{
    return status;
}
void OrderObject::setstatus(const int &v)
{
    status = v;
}
int OrderObject::getservice_fee() const
{
    return service_fee;
}
void OrderObject::setservice_fee(const int &v)
{
    service_fee = v;
}
int OrderObject::getdis_shop_fee() const
{
    return dis_shop_fee;
}
void OrderObject::setdis_shop_fee(const int &v)
{
    dis_shop_fee = v;
}

QString OrderObject::getChannel() const
{
    return channel;
}
void OrderObject::setChannel(const QString &v)
{
    channel = v;
}

QString OrderObject::getchannelName() const
{
    return channelName;
}
void OrderObject::setchannelName(const QString &v)
{
    channelName = v;
}

QString OrderObject::getphone() const
{
    return phone;
}
void OrderObject::setphone(const QString& v)
{
    phone = v;
}

QString OrderObject::getaddress() const
{
    return address;
}
void OrderObject::setaddress(const QString& v)
{
    address = v;
}

QString OrderObject::getcustomer() const
{
    return customer;
}
void OrderObject::setcustomer(const QString& v)
{
    customer = v;
}

QString OrderObject::getdelivery_party() const
{
    return delivery_party;
}
void OrderObject::setdelivery_party(const QString& v)
{
    delivery_party = v;
}

QString OrderObject::getOrder_id() const
{
    return order_id;
}

void OrderObject::setOrder_id(const QString &v)
{
    order_id = v;
}

QString OrderObject::getposorder_id() const
{
    return posorder_id;
}

void OrderObject::setposorder_id(const QString &v)
{
    posorder_id = v;
}

int OrderObject::getpaid_fee() const
{
    return paid_fee;
}

void OrderObject::setpaid_fee(const int &v)
{
    paid_fee = v;
}

int OrderObject::getshop_fee() const
{
    return shop_fee;
}

void OrderObject::setshop_fee(const int &v)
{
    shop_fee = v;
}

int OrderObject::getproduct_fee() const
{
    return product_fee;
}

void OrderObject::setproduct_fee(const int &v)
{
    product_fee=v;
}

int OrderObject::getrest_fee() const
{
    return rest_fee ;
}

void OrderObject::setrest_fee(const int &v)
{
    rest_fee = v;
}

int OrderObject::getuser_fee() const
{
    return user_fee ;
}

void OrderObject::setuser_fee(const int &v)
{
    user_fee = v;
}

QString OrderObject::getCoupon() const
{
    return coupon;
}

void OrderObject::setCoupon(const QString &v)
{
    coupon = v;
}

QString OrderObject::getRemark() const
{
    return remark;
}

void OrderObject::setRemark(const QString &v)
{
    remark = v;
}

int OrderObject::getCreate_time() const
{
    return create_time;
}

void OrderObject::setCreate_time(const int &v)
{
    create_time = v;
}

int OrderObject::getExpire_time() const
{
    return expire_time;
}

void OrderObject::setExpire_time(const int &v)
{
    expire_time = v;
}

QString OrderObject::getTimestamp() const
{
    return timestamp;
}

void OrderObject::setTimestamp(const QString &v)
{
    timestamp = v;
}

QString OrderObject::getpay_type() const
{
    return pay_type;
}

void OrderObject::setpay_type(const QString &v)
{
    pay_type = v;
}

QString OrderObject::getprintcfg() const
{
    return printcfg;
}

void OrderObject::setprintcfg(const QString &v)
{
    printcfg = v;
}

int OrderObject::gettotal_fee() const
{
    return total_fee;
}

void OrderObject::settotal_fee(const int &v)
{
    total_fee = v;
}
int OrderObject::getdiscount_fee() const
{
    return discount_fee;
}

void OrderObject::setdiscount_fee(const int &v)
{
    discount_fee = v;
}

int OrderObject::getsend_fee() const
{
    return send_fee;
}

void OrderObject::setsend_fee(const int &v)
{
    send_fee = v;
}
int OrderObject::gettotal_Amount() const
{
    return total_amount;
}

void OrderObject::settotal_Amount(const int &v)
{
    total_amount = v;
}

int OrderObject::getchannelNum() const
{
    return channelNum;
}

void OrderObject::setchannelNum(const int &v)
{
    channelNum = v;
}

int OrderObject::getorder_index() const
{
    return order_index;
}

void OrderObject::setorder_index(const int &v)
{
    order_index = v;
}

bool OrderObject::gethas_invoiced() const
{
    return has_invoiced;
}

void OrderObject::sethas_invoiced(const bool &v)
{
    has_invoiced = v;
}

QString OrderObject::getinvoice_title() const
{
    return invoice_title;
}

void OrderObject::setinvoice_title(const QString &v)
{
    invoice_title = v;
}

QString OrderObject::getcourier_name() const
{
    return courier_name;
}

void OrderObject::setcourier_name(const QString &v)
{
    courier_name =v;
}

QString OrderObject::getcourier_phone() const
{
    return courier_phone;
}

void OrderObject::setcourier_phone(const QString &v)
{
    courier_phone = v;
}

QString OrderObject::getstatus_desc() const
{
    return status_desc;
}

void OrderObject::setstatus_desc(const QString &v)
{
    status_desc = v;
}

int OrderObject::getdelivery_time() const
{
    return delivery_time;
}

void OrderObject::setdelivery_time(const int &v)
{
    delivery_time = v;
}

QString OrderObject::getfm_id() const
{
    return fm_id;
}

void OrderObject::setfm_id(const QString &v)
{
    fm_id = v;
}

int OrderObject::getdelivery_status() const
{
    return delivery_status;
}

void OrderObject::setdelivery_status(const int &v)
{
    delivery_status = v;
}

int OrderObject::getdelivery_type() const
{
    return delivery_type;
}

void OrderObject::setdelivery_type(const int &v)
{
    delivery_type=v;
}

QStringList OrderObject::getrecords() const
{
    return records;
}

void OrderObject::setrecords(const QStringList &v)
{
    records = v;
}

QStringList OrderObject::getdis_desc() const
{
    return dis_desc;
}

void OrderObject::setdis_desc(const QStringList &v)
{
    dis_desc = v;
}
