#ifndef DATAMANGER_H
#define DATAMANGER_H

#include <QJsonObject>
#include <QJsonArray>
#include "Model/stockObject.h"

class DataManger
{
public:
    static DataManger& GetInstance();

    /* 功能:设置token信息
     * 参数:[1]token
     * 返回:NULL
     * */
    void SetToken(const QString& token);
    /* 功能:获取登录数据
     * 参数:[1]门店号[2]密码[3]收银机号[4]收银员号
     * 返回:登录数据
     * */
    QJsonObject GetLoginData(const QString& storeId, const QString& password,
                             const QString& stationId, const QString& cashierId);
    /* 功能:获取拉取订单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetPullOrderData(const QString& timestamp);
    /* 功能:获取拉取配送员数据
     * 参数:[1]门店号[2]渠道代码
     * 返回:登录数据
     * */
    QJsonObject GetPullDeliverData(const QString& storeId, const QString& channelCode,const QString& orderId);
    /* 功能:获取确认订单数据
     * 参数:[1]订单编号[2]配送员编号[3]配送员姓名[4]配送员电话
     * 返回:登录数据
     * */
    QJsonObject GetConfirmOrderData(const QString& orderId, const QString& deliverId,
                                    const QString& deliverName, const QString& deliverPhone);
    /* 功能:获取拒绝订单数据
     * 参数:[1]拒单原因[2]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetRefuseOrderData(int refuseCode, const QString& orderId);
    /* 功能:获取送出订单数据
     * 参数:[1]订单编号[2]配送员编号[3]配送员姓名[4]配送员电话
     * 返回:登录数据
     * */
    QJsonObject GetSendOrderData(const QString& orderId, const QString &deliverId, const QString &deliverName, const QString &deliverPhone);
    /* 功能:获取完成订单数据
     * 参数:[1]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetCompleteOrderData(const QString& orderId);
    /* 功能:获取商家主动退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefundOrderData(const QString& reason, const QString& orderId);
    /* 功能:获取同意退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetAgreeRefundOrderData(const QString& orderId);

    /* 功能:获取退款详情数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefundDetailData(const QString& orderId);


    /* 功能:获取拒绝退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefuseRefundData(const QString& reason, const QString& orderId);
    /* 功能:获取同步库存数据
     * 参数:[1]库存信息
     * 返回:同步库存数据
     * */
    QJsonObject GetSynStockData(const QList<StockObject>& stockList);

    /* 功能:获取汇报销售单写入结果数据
     * 参数:[1]订单ID[2]错误信息
     * 返回:汇报销售单写入结果数据
     * */
    QJsonObject GetReportOERData(const QString& orderId, int status, const QString& error);


    /* 功能:获取拉取菜品信息数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetPullDishesData(const QString &channelCode);
    /* 功能:获取更新菜品信息数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetUpdDishesData(QString channelCode, QString disheId, int status);

    QJsonObject GetUpdDishesForRefData(QString channelCode, QMap<QString, int> dishesMap);

    /* 功能:获取门店平台信息数据
     * 参数:NULL
     * 返回:数据
     * */
    QJsonObject GetStoreChannelInfoData();
    /* 功能:获取设置门店平台数据
     * 参数:NULL
     * 返回:数据
     * */
    QJsonObject GetOperatingStatusData(const QString& channel, int status);

    /* 功能:获取日结单请求数据
     * 参数:NULL
     * 返回:数据
     * */
    QJsonObject GetDailyStatementData();
private:
    DataManger(){}
    DataManger(DataManger const&);
    DataManger& operator=(DataManger const&);
    // token
    QString m_token;
};

#endif // DATAMANGER_H
