#include "dataManger.h"
#include "preDefine.h"
#include "DTools/configManger.h"

// 请求类型
enum
{
    LOGIN = 10, PULL_ORDER, CONFIRM_ORDER,
    REFUSE_ORDER,COMPLETE_ORDER = 16,
    AGREE_REFUND=17,
    REFUSE_REFUND = 18,SEND_ORDER = 19,
    REFUND_ORDER = 20, GET_DELIVER=21,
    REPORT_BILL_RESULT = 23,
    PULL_DISHES = 24, UPD_DISHES_STATUS = 25,
    GET_STORE_CHANNEL_INFO = 28,SET_STORE_OPERATING_STATUS = 29,
    UPDATE_STOCK=80
};

DataManger &DataManger::GetInstance()
{
    static DataManger dm;
    return dm;
}

void DataManger::SetToken(const QString &token)
{
    m_token = token;
}

QJsonObject DataManger::GetLoginData(const QString &storeId, const QString &password, const QString &stationId, const QString &cashierId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, LOGIN);
    cObj.insert(JSON_USERNAME, storeId);
    cObj.insert(JSON_PASSWORD, password);  
    rObj.insert(JSON_CURRENTUSER, cObj);
    rObj.insert(JSON_STATIONID, stationId);
    rObj.insert(JSON_OPERATORID, cashierId);
    return rObj;
}

QJsonObject DataManger::GetPullOrderData(const QString &timestamp)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, PULL_ORDER);
    rObj.insert(JSON_TIMESTAMPS, timestamp);
    rObj.insert(JSON_AUTOCONFIRM, ConfigManger::GetInstance().GetOutConfirm());
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetPullDeliverData(const QString &storeId, const QString &channelCode, const QString &orderId)
{
    QJsonObject rObj,cObj;
    cObj.insert(JSON_ORDERID,orderId);
    rObj.insert(JSON_ORDER,cObj);
    rObj.insert(JSON_REQTYPE, GET_DELIVER);
    rObj.insert(JSON_STOREID, storeId);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetConfirmOrderData(const QString &orderId, const QString &deliverId, const QString &deliverName, const QString &deliverPhone)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, CONFIRM_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_DELIVERYID, deliverId);
    cObj.insert(JSON_DELIVERYNAME, deliverName);
    cObj.insert(JSON_DELIVERYPHONE, deliverPhone);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetRefuseOrderData(int refuseCode, const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REFUSE_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASONCODE, refuseCode);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetSendOrderData(const QString &orderId, const QString &deliverId, const QString &deliverName, const QString &deliverPhone)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, SEND_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_DELIVERYID, deliverId);
    cObj.insert(JSON_DELIVERYNAME, deliverName);
    cObj.insert(JSON_DELIVERYPHONE, deliverPhone);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetCompleteOrderData(const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, COMPLETE_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetRefundOrderData(const QString &reason, const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REFUND_ORDER);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASON, reason);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetAgreeRefundOrderData(const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, AGREE_REFUND);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASON, "");
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetRefundDetailData(const QString &orderId)
{
    QJsonObject json, order;
    json.insert("reqtype", 27);
    order.insert("order_id", orderId);
    json.insert("order", order);
    json.insert("token", m_token);
    return json;
}

QJsonObject DataManger::GetRefuseRefundData(const QString &reason, const QString &orderId)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REFUSE_REFUND);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert(JSON_REASON, reason);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetSynStockData(const QList<StockObject> &stockList)
{
    QJsonObject rObj;
    QJsonArray cObj;
    rObj.insert(JSON_REQTYPE, UPDATE_STOCK);
    for(int i=0; i<stockList.count(); i++)
    {
        QJsonObject ccObj;
        ccObj.insert(JSON_STOCKID, stockList.at(i).id);
        ccObj.insert(JSON_STOCKUPC, stockList.at(i).upc);
        ccObj.insert(JSON_STOCK, stockList.at(i).num);
        cObj.insert(i, ccObj);
    }
    rObj.insert(JSON_STOCKARRAY, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetReportOERData(const QString &orderId, int status, const QString &error)
{
    QJsonObject rObj, cObj;
    rObj.insert(JSON_REQTYPE, REPORT_BILL_RESULT);
    cObj.insert(JSON_ORDERID, orderId);
    cObj.insert("bill_status", status);
    cObj.insert(JSON_REASON, error);
    rObj.insert(JSON_ORDER, cObj);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_POSVERSION, APP_VERSION);
    return rObj;
}

QJsonObject DataManger::GetPullDishesData(const QString& channelCode)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, PULL_DISHES);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetUpdDishesData(QString channelCode, QString disheId, int status)
{
    QJsonObject rObj;
    QJsonArray dishes;
    QJsonObject cObj;
    cObj.insert("code", disheId);
    cObj.insert("status", status);
    dishes.append(cObj);

    rObj.insert(JSON_REQTYPE, UPD_DISHES_STATUS);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert("dishes", dishes);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetUpdDishesForRefData(QString channelCode, QMap<QString, int> dishesMap)
{
    QJsonObject rObj;
    QJsonArray dishes;
    QMap<QString, int>::iterator it;
    for(it = dishesMap.begin();  it!=dishesMap.end();  it++)
    {
        QJsonObject cObj;
        cObj.insert("code", it.key());
        cObj.insert("status", it.value());
        dishes.append(cObj);
    }

    rObj.insert(JSON_REQTYPE, UPD_DISHES_STATUS);
    rObj.insert(JSON_CHANNEL, channelCode);
    rObj.insert("dishes", dishes);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetStoreChannelInfoData()
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, GET_STORE_CHANNEL_INFO);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}

QJsonObject DataManger::GetOperatingStatusData(const QString &channel, int status)
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, SET_STORE_OPERATING_STATUS);
    rObj.insert(JSON_TOKEN, m_token);
    rObj.insert(JSON_CHANNEL, channel);
    rObj.insert("business_status", status);
    return rObj;
}

QJsonObject DataManger::GetDailyStatementData()
{
    QJsonObject rObj;
    rObj.insert(JSON_REQTYPE, 260);
    rObj.insert(JSON_TOKEN, m_token);
    return rObj;
}
