#include "refuseForm.h"
#include "ui_refuseForm.h"
#include <QDebug>

RefuseForm::RefuseForm(QWidget *parent) :
    QDialog(parent),
    m_orderObject(NULL),
    ui(new Ui::RefuseForm)
{
    ui->setupUi(this);
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    this->setModal(true);
    ui->refuseBtnOk->setEnabled(false);

    m_refDishesForm = new refDishesForm(this);
    ui->reasonNULL->hide();

}

RefuseForm::~RefuseForm()
{
    delete ui;
}

void RefuseForm::SetOrderInfo(OrderObject *obj)
{
    _Init();
    m_orderObject = obj;
}


void RefuseForm::on_refuseBtnCancle_clicked()
{
    this->reject();
}

void RefuseForm::on_refuseBtnOk_clicked()
{
    this->accept();
}

void RefuseForm::on_reason1_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonCode="餐厅已打烊";
    }
}

void RefuseForm::on_reason2_toggled(bool checked)
{
    if(m_orderObject!=NULL&&checked)
    {
        m_refDishesForm->InitData(m_orderObject);
        if(QDialog::Accepted == m_refDishesForm->exec())
        {
            ui->refuseBtnOk->setEnabled(true);
            m_reasonCode="菜品已售完";
            on_refuseBtnOk_clicked();
        }else
        {
            _Init();
        }
    }
}

void RefuseForm::on_reason3_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonCode="餐厅太忙";
    }
}

void RefuseForm::on_reason4_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonCode="联系不上客户";
    }
}

void RefuseForm::on_reason5_toggled(bool checked)
{
    if(checked)
    {
        ui->refuseBtnOk->setEnabled(true);
        m_reasonCode="无人配送";
    }
}

void RefuseForm::_Init()
{
    qDebug() << __FUNCTION__;
    ui->reasonNULL->toggle();
    ui->refuseBtnOk->setEnabled(false);
}
