#include "floatForm.h"
#include "ui_floatForm.h"
#include <QPixmap>
#include<QRect>
#include "DTools/configManger.h"
#include "preDefine.h"
#include "QsLog.h"
#include<QDesktopWidget>
#include <windows.h>
#include <QThread>

FloatForm::FloatForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FloatForm)
{
    ui->setupUi(this);

    m_bReminding = false;
    msgsound = new QSound("");

    QPixmap imgNormal(":float_normal.png");
    m_imgNormalSize = imgNormal.size();
    QPixmap imgRemind(":float_remind.png");
    m_imgRemindSize = imgRemind.size();

    m_animation.setTargetObject(this);
    m_animation.setPropertyName("windowOpacity");
    m_animation.setDuration(ConfigManger::GetInstance().GetBlinkInterval());
    m_animation.setEasingCurve(QEasingCurve::InOutSine);

//    m_raiseTimer.start(2000);
    m_raiseTimer.setInterval(2000);
    connect(&m_raiseTimer, &QTimer::timeout, this, &FloatForm::onRaise);

    _Init();
}

FloatForm::~FloatForm()
{
    QLOG_INFO()<<"delete floatform";
    delete ui;
}

void FloatForm::mouseMoveEvent(QMouseEvent *event)
{
    if ((event->buttons()==Qt::LeftButton) && m_bMousePress)
    {
        QPoint moveAmount = event->globalPos() - m_lastMousePos;
        m_absMove += moveAmount;
        QDesktopWidget* desktopWidget = QApplication::desktop();
        //获取设备屏幕大小
        QRect screenRect = desktopWidget->screenGeometry();
        int g_nActScreenX = screenRect.width()-150;
        int g_nActScreenY = screenRect.height()-100;
        if(g_nActScreenX>(pos() + moveAmount).x())
        {
            g_nActScreenX=(pos() + moveAmount).x();

        }
        if(g_nActScreenX<=0)
        {
            g_nActScreenX=0;
        }
        if(g_nActScreenY>(pos() + moveAmount).y())
        {
            g_nActScreenY=(pos() + moveAmount).y();

        }
        if(g_nActScreenY<=0)
        {
            g_nActScreenY=0;
        }
        move(QPoint(g_nActScreenX,g_nActScreenY));
        m_lastMousePos = event->globalPos();
        m_bMouseMove = true;
    }
}

void FloatForm::mousePressEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = true;
        m_lastMousePos = event->globalPos();
        m_absMove = QPoint(0,0);
    }
}

void FloatForm::mouseReleaseEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = false;
    }
    int x = m_absMove.x();
    int y = m_absMove.y();
    if(!m_bMouseMove || (((x>-10)&&(x<10))&&((y>-10)&&(y<10))))
    {
        hide();
        m_raiseTimer.stop();
        emit showMainForm();
        onStopRemind();
        QLOG_INFO()<<"emit showMainForm";
    }else
    {
        ConfigManger::GetInstance().setFloatInitPostion(this->pos());
    }

    m_bMouseMove = false;
}

bool FloatForm::nativeEvent(const QByteArray &eventType, void *message, long *result)
{
    MSG* msg = static_cast<MSG*>(message);
    switch(msg->message)
    {
    case WM_CLOSE:
        QLOG_INFO()<<"关闭窗口";
    }
    return false;
}

void FloatForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);
    setAttribute(Qt::WA_TranslucentBackground);

    setFixedSize(m_imgNormalSize);
    setStyleSheet("#floatWdg{ border-image: url(:float_normal.png); }");

    move(ConfigManger::GetInstance().GetFloatInitPostion());
}

void FloatForm::_Blink()
{
    QEventLoop loop;
    connect(&m_animation, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
    this->setFixedSize(m_imgRemindSize);
    ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_remind.png)}");
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
    this->setFixedSize(m_imgNormalSize);
    ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_normal.png)}");
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();

    if(m_bReminding)
    {
        QTimer::singleShot(ConfigManger::GetInstance().GetBlinkInterval(), this, &FloatForm::_Blink);
    }
}

void FloatForm::_PlayWav()
{
    if(msgsound->isFinished())
    {
        msgsound->play(m_remindWav);
    }

    if(m_bReminding)
    {
        QTimer::singleShot(m_wavPlayInterval, this, &FloatForm::_PlayWav);
    }
    else{
        msgsound->stop();
    }
}

void FloatForm::onStartRemind(int type)
{
    qDebug() <<"播放线程号"<<  QThread::currentThreadId();
    if(m_bReminding)
    {

        return;
    }
    m_bReminding = true;

    switch(type)
    {
    case 0:
        m_remindWav = QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_NEWORDERTIME;
        break;
    case 1:
        m_remindWav = QString("%1/wav/msg1.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = 20000 + VALUE_REFUNDORDERTIME;
        break;
    default:
        m_remindWav = "";
        break;
    }

    QTimer::singleShot(1000*10,this, &FloatForm::onStopRemind);

    _Blink();
    _PlayWav();
}

void FloatForm::onStopRemind()
{
    m_bReminding = false;
}

void FloatForm::onStartNetRemind()
{
    qDebug() << __FUNCTION__;
    m_remindWav = QString("%1/wav/msg2.wav").arg(QApplication::applicationDirPath());
    m_wavPlayInterval=1000*60*5;
    m_bReminding=true;
    _PlayWav();
}

void FloatForm::onStopNetRemind()
{
    m_bReminding=false;
}

void FloatForm::onShow()
{
    QLOG_INFO()<<"show the floatform";
    this->show();
    m_raiseTimer.start();
}

void FloatForm::onRaise()
{
    if(this->isVisible())
    {
        //QLOG_INFO()<<"window is active";
    }
    else{
        QLOG_INFO()<<"visible is false";
        this->setVisible(true);
    }
    //QLOG_INFO()<<"floatform raised";
    this->raise();
}
