#include "dishesPickForm.h"
#include "ui_dishesPickForm.h"
#include <QDebug>
#include "Control/flowControl.h"

DishesPickForm::DishesPickForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DishesPickForm)
{
    ui->setupUi(this);

    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    this->setModal(true);

    connect(this, &DishesPickForm::doUpdDishes, &FlowControl::GetInstance(), &FlowControl::onUpdDishes);
}

DishesPickForm::~DishesPickForm()
{
    delete ui;
}

void DishesPickForm::Init(QString dishesId, QMap<QString, int> infos)
{
   m_dishesId = dishesId;

    for(int i=1; i<7; i++)
    {
        QPushButton *btn = findChild<QPushButton*>(QString("dpfBtn_%1").arg(i));
        btn->setChecked(false);
        btn->setEnabled(false);
    }

    int index = 1;
    foreach (QString channelNameCode, infos.keys()) {
        QPushButton *btn = findChild<QPushButton*>(QString("dpfBtn_%1").arg(index++));
        if( btn != NULL )
        {
            btn->setText(channelNameCode.split(":").at(0));
            btn->setProperty("channelNameCode", channelNameCode);
            btn->setChecked(true);
            btn->setEnabled(true);
        }

    }
}

void DishesPickForm::on_dpfBtn_xj_clicked()
{
    QStringList channels;
    for(int i=1; i<7; i++)
    {
        QPushButton *btn = findChild<QPushButton*>(QString("dpfBtn_%1").arg(i));
        if( btn->isChecked() )
        {
            channels.append(btn->property("channelNameCode").toString());
        }
    }
    emit doUpdDishes(channels, m_dishesId, 0);

    this->hide();
}

void DishesPickForm::on_dpfBtn_sj_clicked()
{
    QStringList channels;
    for(int i=1; i<7; i++)
    {
        QPushButton *btn = findChild<QPushButton*>(QString("dpfBtn_%1").arg(i));
        if( btn->isChecked() )
        {
            channels.append(btn->property("channelNameCode").toString());
        }
    }

    emit doUpdDishes(channels, m_dishesId, 1);
    this->hide();
}

void DishesPickForm::on_dpfBtn_cancle_clicked()
{
    this->hide();
}
