#include "bstatusItem.h"
#include "ui_bstatusItem.h"
#include <QStringList>
#include "Control/flowControl.h"

BStatusItem::BStatusItem(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BStatusItem)
{
    ui->setupUi(this);

    connect(this, &BStatusItem::setStoreOperatingStatus, &FlowControl::GetInstance(), &FlowControl::onSetStoreOperatingStatus);
    connect(&FlowControl::GetInstance(), &FlowControl::setStoreOperatingStatusFinsh, this, &BStatusItem::onSetStoreOperatingStatusFinsh);
}

BStatusItem::~BStatusItem()
{
    delete ui;
}

void BStatusItem::InitData(QString str)
{
    QStringList list = str.split(":");

    m_channelCode = list.at(0);
    m_channelName = list.at(1);
    m_channelStatus = QString(list.at(2)).toInt();

    ui->btsItemLab->setText(m_channelName);

    if(m_channelStatus == 0)
    {
        //  置休中
        ui->btsItemStatus->setText("<font color='#ff0000'>已置休</font>");
        ui->btsItemBtn->setText("营业");
    }else
    {
        // 营业中
        ui->btsItemStatus->setText("<font color='#22b807'>营业中</font>");
        ui->btsItemBtn->setText("置休");
    }
}

void BStatusItem::onSetStoreOperatingStatusFinsh(QString channel)
{
    if(!channel.compare(m_channelCode))
    {
        m_channelStatus = m_channelStatus==0?1:0;

        if(m_channelStatus == 0)
        {
            // 关店中
            ui->btsItemStatus->setText("<font color='#ff0000'>已置休</font>");
            ui->btsItemBtn->setText("营业");
        }else
        {
            // 营业中
            ui->btsItemStatus->setText("<font color='#22b807'>营业中</font>");
            ui->btsItemBtn->setText("置休");
        }
    }
}

void BStatusItem::on_btsItemBtn_clicked()
{
    emit setStoreOperatingStatus(m_channelCode, m_channelStatus==0?1:0);
}
