#ifndef PRODUCTOBJECT_H
#define PRODUCTOBJECT_H

#include "baseObject.h"

class ProductObject : public BaseObject
{
    Q_OBJECT
public:
    ProductObject(QObject *parent=0)
        :BaseObject(parent),
        unit_ratio(-1){}

    /* 功能:从Json对象初获取数据
     * 参数:[1]JSon对象
     * 返回:NULL
     * */
    void FromJson(const QJsonObject& json);

    Q_PROPERTY (QString pid READ getPid WRITE setPid)
    Q_PROPERTY (QString name READ getName WRITE setName)
    Q_PROPERTY (QString upc READ getupc WRITE setupc)
    Q_PROPERTY (int price READ getprice WRITE setprice)
    Q_PROPERTY (int productAmount READ getProductAmount WRITE setProductAmount)
    Q_PROPERTY (int cost READ getcost WRITE setcost)
    Q_PROPERTY (int unit_ratio READ getunit_ratio WRITE setunit_ratio)
    Q_PROPERTY (QString stock_barcode READ getstock_barcode WRITE setstock_barcode)
    Q_PROPERTY (int pack_charge READ getpack_charge WRITE setpack_charge)
    Q_PROPERTY(QString bsk_num READ getbsk_num WRITE setbsk_num)

    QString pid;
    QString name;
    QString upc;
    int price;
    int productAmount;
    QString bsk_num;


    QString stock_barcode;     // 鲜丰特有入账短编码
    int pack_charge;   // 鲜丰特有的包装费(用于核算成本)

    int cost;   // 成本价
    int unit_ratio; // 商品系数
    QList<ProductObject *> sub_products; // 子商品


protected:

    QString getbsk_num() const;
    void setbsk_num(const QString& v);

    int getpack_charge() const;
    void setpack_charge(const int& v);

    QString getstock_barcode() const;
    void setstock_barcode(const QString& v);

    int getcost() const;
    void setcost(const int& v);

    int getunit_ratio() const;
    void setunit_ratio(const int& v);

    QString getPid() const ;
    void setPid(const QString& v);

    QString getName() const ;
    void setName(const QString& v);

    QString getupc() const ;
    void setupc(const QString& v);

    int getprice() const ;
    void setprice(const int& v);

    int getProductAmount() const ;
    void setProductAmount(const int &v);
};

#endif // PRODUCTOBJECT_H
