#include "productObject.h"
#include <QJsonArray>

void ProductObject::FromJson(const QJsonObject &json)
{
    qDeleteAll(sub_products);
    sub_products.clear();
    FetchDataFromJson(json);
    QJsonArray products = json["sub_products"].toArray();
    foreach(QJsonValue product, products)
    {
        QJsonObject proJson = product.toObject();
        ProductObject *proObject = new ProductObject(this);
        proObject->FetchDataFromJson(proJson);
        sub_products.append(proObject);
    }

    return;
}

QString ProductObject::getbsk_num() const
{
    return bsk_num;
}

void ProductObject::setbsk_num(const QString &v)
{
    bsk_num = v;
}

int ProductObject::getpack_charge() const
{
    return pack_charge;
}

void ProductObject::setpack_charge(const int &v)
{
    pack_charge = v;
}

QString ProductObject::getstock_barcode() const
{
    return stock_barcode;
}

void ProductObject::setstock_barcode(const QString &v)
{
    stock_barcode = v;
}

int ProductObject::getcost() const
{
    return cost;
}

void ProductObject::setcost(const int &v)
{
    cost = v;
}

int ProductObject::getunit_ratio() const
{
    return unit_ratio;
}

void ProductObject::setunit_ratio(const int &v)
{
    unit_ratio = v;
}

QString ProductObject::getPid() const
{
    return pid;
}
void ProductObject::setPid(const QString &v)
{
    pid = v;
}

QString ProductObject::getName() const
{
    return name;
}
void ProductObject::setName(const QString &v)
{
    name = v;
}

QString ProductObject::getupc() const
{
    return upc;
}
void ProductObject::setupc(const QString &v)
{
    upc = v;
}

int ProductObject::getprice() const
{
    return price;
}
void ProductObject::setprice(const int &v)
{
    price = v;
}

int ProductObject::getProductAmount() const
{
    return productAmount;
}
void ProductObject::setProductAmount(const int &v)
{
    productAmount = v;
}
