#ifndef DISHESOBJECT_H
#define DISHESOBJECT_H

#include <QObject>
#include "baseObject.h"

class dishesObject : public BaseObject
{
    Q_OBJECT
public:
    explicit dishesObject(QObject *parent = 0):
        BaseObject(parent){}

public:
    Q_PROPERTY (QString code READ getcode WRITE setcode)
    Q_PROPERTY (QString name READ getname WRITE setname)
    Q_PROPERTY (int status READ getstatus WRITE setstatus)
    Q_PROPERTY (QString pic READ getpic WRITE setpic)
    Q_PROPERTY (int price READ getprice WRITE setprice)
    Q_PROPERTY (QString unit READ getunit WRITE setunit)
    Q_PROPERTY (int rank READ getrank WRITE setrank)
    Q_PROPERTY (QString description READ getdescription WRITE setdescription)

    QString code;
    QString name;
    int status;
    QString pic;
    int price;
    QString unit;
    int rank;
    QString description;

    // 自定义属性
    QMap<QString, int> channelCode_status;  // 所属平台及上下架状态

protected:
    inline QString getcode(){ return code; }
    inline void setcode(const QString& v){ code=v; }

    inline QString getname(){ return name; }
    inline void setname(const QString& v){ name=v; }

    inline int getstatus(){ return status; }
    inline void setstatus(const int& v){ status=v; }

    inline QString getpic(){ return pic; }
    inline void setpic(const QString& v){ pic=v; }

    inline int getprice(){ return price; }
    inline void setprice(const int& v){ price=v; }

    inline QString getunit(){ return unit; }
    inline void setunit(const QString& v){ unit=v; }

    inline int getrank(){ return rank; }
    inline void setrank(const int& v){ rank=v; }

    inline QString getdescription(){ return description; }
    inline void setdescription(const QString& v){ description=v; }
};

#endif // DISHESOBJECT_H
