﻿#include <QCoreApplication>
#include "qfmclient.h"
#include "log.h"

//不显示控制台
//#pragma comment( linker, "/subsystem:\"windows\" /entry:\"mainCRTStartup\"" )
BOOL WINAPI HandlerRoutine(_In_ DWORD dwCtrlType);
QFmClient* pFm = nullptr;

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    SetConsoleCtrlHandler(HandlerRoutine, TRUE);
    InitLogger();
    QLOG_INFO()<<"start client...";
    QFmClient client;
    pFm = &client;
    client.start();
    return a.exec();
}

BOOL WINAPI HandlerRoutine(_In_ DWORD dwCtrlType)
{
    switch (dwCtrlType)
    {
    // Handle the CTRL + C signal.
    case CTRL_C_EVENT:
    case CTRL_CLOSE_EVENT:
        OutputDebugStringA("quit client...\n");
        pFm->CloseSock();
        pFm->wait();
        QLOG_INFO()<<"quit client...\n\n\n\n";
        break;
        // CTRL-CLOSE: confirm that the user wants to exit.
    default:
        break;
    }
    return FALSE;
}
