﻿#ifndef CONVERT_H
#define CONVERT_H

/*convert pos request json format from
 * 非码支付插件 API 对接说明.pdf
 * to
 * 非码支付FMClient商户版_20170921.pdf
 */

#include <QJsonObject>
#include "common.h"

class Convert
{
public:
    Convert();

    bool FreemudPay(QJsonObject& object, STORE_INFO store_info);               //非码支付
    bool QueryPay(QJsonObject& object, STORE_INFO store_info);                 //支付查询
    bool RefundPay(QJsonObject& object, STORE_INFO store_info);                //支付退款
    bool FreemudPayResponse(QJsonObject& object);       //非码支付回复转换
    bool QueryPayResponse(QJsonObject& object);         //支付查询回复转换
    bool RefundPayResponse(QJsonObject& object);        //支付退款回复转换
};

#endif // CONVERT_H
