﻿#ifndef LOG
#define LOG
#include "QsLog/QsLog.h"
#include <QDir>

static void InitLogger()
{
    QString logPath = qApp->applicationDirPath()+"/log";
    QString logName = qApp->applicationName().append(".log");
    QsLogging::Level logLevel = QsLogging::TraceLevel;
    if(logLevel < QsLogging::TraceLevel || logLevel > QsLogging::OffLevel) {
        logLevel = QsLogging::TraceLevel;
    }
    int logSize = 1;
    int logCount = 20;

    QDir logDir(logPath);
    if(!logDir.exists()) {
        logDir.mkpath(logDir.absolutePath());
    }
    QString logFilePath = logDir.absolutePath()+'/'+logName;
    QsLogging::Logger& logger = QsLogging::Logger::instance();
    logger.setLoggingLevel(logLevel);

    /* 配置输出定向器 */
    /* 输出到指定文件 */
    QsLogging::DestinationPtr fileDestination(QsLogging::DestinationFactory::MakeFileDestination(
                                                  logFilePath,
                                                  QsLogging::EnableLogRotation, QsLogging::MaxSizeBytes(1024*1024*logSize),
                                                  QsLogging::MaxOldLogCount(logCount)));
    logger.addDestination(fileDestination);
    /* 输出到控制台 */
    //    QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
    //    logger.addDestination(consleDest);
}

#endif // LOG

