﻿#include "convert.h"
#include <QJsonArray>
#include <QJsonDocument>
#include <QDebug>
#include "QsLog/QsLog.h"

Convert::Convert()
{

}

//非码支付
bool Convert::FreemudPay(QJsonObject &object, STORE_INFO store_info)
{
    QJsonObject newObject;
    QJsonArray transactionArray;
    QJsonObject transactionObject;

    newObject.insert("ver",2);
    newObject.insert("reqtype",72);

    newObject.insert("partnerId",store_info.partner_id);
    newObject.insert("store_id",store_info.store_id);
    newObject.insert("station_id",store_info.pos_id);
    newObject.insert("operator_id",store_info.operator_id);
    newObject.insert("business_date",store_info.business_date);

    if(object.contains("trans_id"))
    {
        QString trans_id  = object.value("trans_id").toString();
        newObject.insert("trans_id",trans_id);
    }

    if(object.contains("order_amount"))
    {
        int order_amount  = object.value("order_amount").toInt();
        transactionObject.insert("amount",order_amount);
    }
    if(object.contains("undis_amount"))
    {
        int undis_amount  = object.value("undis_amount").toInt();
        transactionObject.insert("undis_amount",undis_amount);
    }
    if(object.contains("barcode"))
    {
        QString barcode  = object.value("barcode").toString();
        transactionObject.insert("code",barcode);
    }
    if(object.contains("products"))
    {
        QJsonValue products  = object.value("products");
        if(products.isArray())
            transactionObject.insert("products",products);
    }
    transactionArray.append(transactionObject);
    newObject.insert("transactions",transactionArray);
    qSwap(object, newObject);
    return true;
}

//支付查询
bool Convert::QueryPay(QJsonObject &object, STORE_INFO store_info)
{
    QJsonObject queryObject;
    QString fm_order_id;
    QString trans_id;
    if(object.contains("trans_id"))
    {
        trans_id = object.value("trans_id").toString();
        queryObject.insert("trans_id",trans_id.toInt());
    }
    else
    {
        QLOG_ERROR()<<"can not find trans_id in json request!";
        return false;
    }
    if(object.contains("fm_order_id"))
    {
        fm_order_id  = object.value("fm_order_id").toString();
    }
    queryObject.insert("ver", 4);
    queryObject.insert("reqtype", 52);

    queryObject.insert("partnerId",store_info.partner_id.toInt());
    queryObject.insert("store_id",store_info.store_id);
    queryObject.insert("station_id",store_info.pos_id);
    queryObject.insert("operator_id",store_info.operator_id);

    queryObject.insert("fmid",fm_order_id);
    queryObject.insert("sign",QString());
    qSwap(object,queryObject);
    return true;
}

//支付退款
bool Convert::RefundPay(QJsonObject &object, STORE_INFO store_info)
{
    QJsonObject refundObject;
    QJsonArray transactionArray;
    QJsonObject transactionObject;

    QString trans_id;
    QJsonValue fmid;
    int refund_amount = 0;

    if(object.contains("trans_id"))
        trans_id = object.value("trans_id").toString();
    if(object.contains("fm_order_id"))
        fmid = object.value("fm_order_id");
    if(object.contains("refund_amount"))
        refund_amount = object.value("refund_amount").toInt();
    refundObject.insert("ver", 2);
    refundObject.insert("reqtype", 62);
    refundObject.insert("partnerId",store_info.partner_id.toInt());
    refundObject.insert("store_id",store_info.store_id);
    refundObject.insert("station_id",store_info.pos_id);
    refundObject.insert("operator_id",store_info.operator_id);
    refundObject.insert("business_date",store_info.business_date);
    refundObject.insert("trans_id", trans_id.toInt());

    transactionObject.insert("fmid",fmid);
    transactionObject.insert("refund_count",refund_amount);
    transactionArray.append(transactionObject);
    refundObject.insert("transactions",transactionArray);
    qSwap(object,refundObject);
    return true;
}

//非码支付回复转换
bool Convert::FreemudPayResponse(QJsonObject &object)
{
    QJsonObject payResponseObject;
    QJsonArray pay_idsArray;
    QJsonObject pay_idObject;
    QJsonValue ext;
    int statusCode = 100;
    if(object.contains("statusCode"))
    {
        statusCode = object.value("statusCode").toInt();
        payResponseObject.insert("status_code",statusCode);
    }
    if(object.contains("msg"))
    {
        QJsonValue msg = object.value("msg");
        payResponseObject.insert("msg",msg);
    }
    if(statusCode != 100)
    {
        qSwap(object,payResponseObject);
        return true;
    }
    if(object.contains("pay_transId"))
    {
        QJsonValue fm_trans_id = object.value("pay_transId");
        payResponseObject.insert("fm_trans_id",fm_trans_id);
    }
    if(object.contains("fmId"))
    {
        QJsonValue fm_order_id = object.value("fmId");
        payResponseObject.insert("fm_order_id",fm_order_id);
    }

    if(object.contains("total_amount"))
    {
        QJsonValue paid_total_amount = object.value("total_amount");
        payResponseObject.insert("paid_total_amount",paid_total_amount);
        pay_idObject.insert("pay_amount",paid_total_amount);
    }
    if(object.contains("invoice_amount"))
    {
        QJsonValue invoice_amount = object.value("invoice_amount");
        payResponseObject.insert("invoice_amount",invoice_amount);
    }
    if(object.contains("mcoupon_amount") && object.contains("pcoupon_amount"))
    {
        int platform_discount = object.value("mcoupon_amount").toInt();
        int merchant_discount = object.value("pcoupon_amount").toInt();
        payResponseObject.insert("discount_amount",platform_discount + merchant_discount);
        pay_idObject.insert("platform_discount",platform_discount);
        pay_idObject.insert("merchant_discount",merchant_discount);
    }
    if(object.contains("pay_ebcode"))
    {
        QJsonValue pay_id = object.value("pay_ebcode");
        pay_idObject.insert("pay_id",pay_id);
    }
    if(object.contains("pay_id"))
    {
        QJsonValue pay_str = object.value("pay_id");
        pay_idObject.insert("pay_str",pay_str);
    }
    if(object.contains("pay_acount"))
    {
        QJsonValue pay_account = object.value("pay_acount");
        pay_idObject.insert("pay_account",pay_account);
    }
    if(object.contains("ext"))
    {
        ext = object.value("ext");
        pay_idObject.insert("ext", ext);
    }

    pay_idsArray.append(pay_idObject);
    payResponseObject.insert("pay_ids",pay_idsArray);
    qSwap(object,payResponseObject);
    return true;
}


//支付查询回复转换
bool Convert::QueryPayResponse(QJsonObject &object)
{
    QJsonObject queryPayResponseObject;
    QJsonArray pay_idsArray;
    QJsonObject pay_idObject;
    QJsonValue ext;
    int statusCode = 100;
    if(object.contains("statusCode"))
    {
        statusCode = object.value("statusCode").toInt();
        queryPayResponseObject.insert("status_code",QString::number(statusCode));
    }
    if(statusCode != 100)
        return true;
    queryPayResponseObject.insert("msg",QString::fromLocal8Bit("成功"));

    if(object.contains("pay_transId"))
    {
        QJsonValue fm_trans_id = object.value("pay_transId");
        queryPayResponseObject.insert("fm_trans_id",fm_trans_id);
    }
    if(object.contains("fmId"))
    {
        QJsonValue fm_order_id = object.value("fmId");
        queryPayResponseObject.insert("fm_order_id",fm_order_id);
    }

    if(object.contains("total_amount"))
    {
        QJsonValue paid_total_amount = object.value("total_amount");
        queryPayResponseObject.insert("paid_total_amount",paid_total_amount);
        pay_idObject.insert("pay_amount",paid_total_amount);
    }
    if(object.contains("invoice_amount"))
    {
        QJsonValue invoice_amount = object.value("invoice_amount");
        queryPayResponseObject.insert("invoice_amount",invoice_amount);
    }
    if(object.contains("mcoupon_amount") && object.contains("pcoupon_amount"))
    {
        int platform_discount = object.value("mcoupon_amount").toInt();
        int merchant_discount = object.value("pcoupon_amount").toInt();
        queryPayResponseObject.insert("discount_amount",platform_discount + merchant_discount);
        pay_idObject.insert("platform_discount",platform_discount);
        pay_idObject.insert("merchant_discount",merchant_discount);
    }
    if(object.contains("pay_ebcode"))
    {
        QJsonValue pay_id = object.value("pay_ebcode");
        pay_idObject.insert("pay_id",pay_id);
    }
    if(object.contains("pay_id"))
    {
        QJsonValue pay_str = object.value("pay_id");
        pay_idObject.insert("pay_str",pay_str);
    }
    if(object.contains("pay_acount"))
    {
        QJsonValue pay_account = object.value("pay_acount");
        pay_idObject.insert("pay_account",pay_account);
    }
    if(object.contains("ext"))
    {
        ext = object.value("ext");
        pay_idObject.insert("ext", ext);
    }

    pay_idsArray.append(pay_idObject);
    queryPayResponseObject.insert("pay_ids",pay_idsArray);
    qSwap(object,queryPayResponseObject);
    return true;
}

//支付退款回复转换
bool Convert::RefundPayResponse(QJsonObject &object)
{

    QJsonObject refundPayResponseObject;
    QJsonValue ext;
    int statusCode = 100;
    if(object.contains("statusCode"))
    {
        statusCode = object.value("statusCode").toInt();
        refundPayResponseObject.insert("status_code",QString::number(statusCode));
    }
    if(statusCode != 100)
    {
        refundPayResponseObject.insert("msg",QString::fromLocal8Bit("失败"));
        qSwap(object,refundPayResponseObject);
        return true;
    }
    refundPayResponseObject.insert("msg",QString::fromLocal8Bit("成功"));

    if(object.contains("ext"))
    {
        ext = object.value("ext");
        refundPayResponseObject.insert("ext", ext);
    }
    qSwap(object,refundPayResponseObject);
    return true;
}
