﻿#ifndef QFMCLIENT_H
#define QFMCLIENT_H

#include <QThread>
#include <windows.h>
#include <QTextStream>
#include <QCoreApplication>

#define MAX_CODE_KEY            32
#define MAX_CTRL_INFO_LEN       16
#define MAX_BUF_LEN             4096
#define MAX_REQ_COUNT           25600
#define ROLL_BACK_FILE_NAME     "fmclient.rbk"

#define SET_STORE_INFO          1000        //设置门店信息
#define FREEMUD_PAY             10031       //非码支付
#define QUERY_PAY               10030       //支付查询
#define REFUND_PAY              10041       //支付退款

class QFmClient : public QThread
{    
    Q_OBJECT
public:
    QFmClient(QObject *parent = NULL);
    void run();
    bool Init(QString proxy_IP, unsigned short proxy_port, unsigned short listen_prot, unsigned short long_timeout, unsigned short short_timeout);
    bool InitStoreInfo();
signals:
    void Error(QString error);

private:
    void CloseSocket(int *sock);
    void GetKey();
    bool StartListenport();
    void CheckRollBackData();
    int Try2ConnectZhProxy();
    int SendCtrlInfo2Proxy();
    void WaitAndSleep(int elapse);
    bool WaitForConnectReqFromPos();
    int ProcessPosReqData(QJsonObject& object);
    bool ConvertRequestJsonFormat(QJsonObject& object);        //convert pos request json format from 非码支付插件 API 对接说明.pdf to 非码支付FMClient商户版_20170921.pdf
    bool ConvertResponseJsonFormat(QJsonObject& object,int nType);
    void SetStoreInfo(QJsonObject& object);             //设置门店信息
    void FreemudPay(QJsonObject& object);               //非码支付
    bool QueryPay(QJsonObject& object);                 //支付查询
    bool RefundPay(QJsonObject& object);                //支付退款
    bool FreemudPayResponse(QJsonObject& object);       //非码支付回复处理
    bool QueryPayResponse(QJsonObject& object);         //支付查询回复处理
    bool RefundPayResponse(QJsonObject& object);        //支付退款回复处理

    void sendSetResponseToPos(bool bFlag);
    void AddReqCount(QJsonObject &object);
    int CheckIsCompleteJsonData(int *count, char *data);
    int RecvSockData(int sock, char *buffer, int length);
    int WaitAndReadDataFromPos(int type, int flag);
    char *DecodeRecvData(char *buf, int length, int *dLength);
    int UTF8ToGBK(unsigned char *lpUTF8Str, unsigned char *lpGBKStr, int nGBKStrLen);
    int GBKToUTF8(unsigned char *lpGBKStr, int gbkLen, unsigned char *lpUTF8Str, int nUTF8StrLen);
    int CheckReqFromPos(char *pJsonData, int dLength, int chkValue);
    int SendSocketData(int sock, char *buf, int length, int flag);
    char *EncodeSendData(char *buf, int length, int *eLength);
    int SendData2ZhProxyAndWaitRspData();
    int RecvAndCheckDataFromSock(int sock, int flag, int type);
    int ProcessZhProxyRspDataAndSend2Pos(int nType);
    int CheckRecvedData();
    void BackupPosReq(char *req);

private:
    bool _endflag;
    char _recvbuf[MAX_BUF_LEN];
    char _tempbuf[MAX_BUF_LEN];
    char _sendbuf[MAX_BUF_LEN];
    char _codeBuf[MAX_BUF_LEN];

    unsigned char _codeKey[MAX_CODE_KEY];

    //proxy IP
    char _proxyIP[30];
    //proxy 端口
    unsigned short _proxyPort;

    //QFMClient监听端口
    unsigned short _clientPort;

    //应用层分段大小(1024)
    unsigned int _fmMSS;
    //监听本地端口的socket
    int _listenSock;
    //接收pos请求的socket
    int _acceptedSock;
    //和proxy交互的socket
    int _zhProxySock;

    //接收数据长度
    int _rcvLength;

    //长超时
    unsigned short _longTimeOut;
    //短超时
    unsigned short _shortTimeOut;
    //当前使用超时
    unsigned short _sockTimeOut;

    char  _keyLength;
    char  _curKeyPos;
    char  _codeFlag;
    char  _reserved;

    //门店信息
    typedef struct _STORE_INFO{
        QString partner_id;     //商户编号
        QString store_id;       //商家门店号
        QString pos_id;         //商家POS机编号
        QString operator_id;    //营业员编号
        QString business_date;  //营业日
        _STORE_INFO(QString _partner_id,
                    QString _store_id,
                    QString _pos_id,
                    QString _operator_id,
                    QString _business_date):
            partner_id(_partner_id),
            store_id(_store_id),
            pos_id(_pos_id),
            operator_id(_operator_id),
            business_date(_business_date){}
    }STORE_INFO;

    STORE_INFO store_info;
    static unsigned int s_reqCount;
};

#endif // QFMCLIENT_H
