#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QEvent>
#include <QKeyEvent>
#include <QPropertyAnimation>

namespace Ui {
class Widget;
}

class Widget : public QWidget
{
    Q_OBJECT

public:
    explicit Widget(QWidget *parent = 0);
    ~Widget();
    void show();
protected:
    void paintEvent(QPaintEvent *);
    void keyPressEvent(QKeyEvent *key);
public slots:

    void close();
    void animationFinished();
signals:
        QString getCode(QString strCode);
private:
    Ui::Widget *ui;
    QString strCode;
    QPropertyAnimation* scanningBar;
    bool animationUp;
};

#endif // WIDGET_H
