#include "widget.h"
#include "ui_widget.h"
#include <QDebug>
#include <QPainter>
#include <QMessageBox>
#include <QJsonObject>
#include <Windows.h>

#pragma comment(lib, "user32.lib")

Widget::Widget(QWidget *parent) :
    QWidget(parent),animationUp(false),
    ui(new Ui::Widget)
{
    ui->setupUi(this);
    connect(ui->btnClose,&QPushButton::clicked,this,&Widget::close);
    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    scanningBar = new QPropertyAnimation(ui->labScaningBar,"geometry",this);
    connect(scanningBar,&QPropertyAnimation::finished,this,&Widget::animationFinished);
    scanningBar->setStartValue( QRect( 0,320,330,33));
    scanningBar->setEndValue( QRect( 0,400, 330,33));
    scanningBar->setDuration(1500);
    scanningBar->start();

     ui->code->setVisible(false);
     ui->code->setFocus();
}

Widget::~Widget()
{
    delete ui;
}

void Widget::show()
{
    setVisible(true);
    setAttribute(Qt::WA_ShowModal, true);
    showNormal();
    HWND hForeWnd = ::GetForegroundWindow();
    DWORD dwForeID = ::GetWindowThreadProcessId(hForeWnd,NULL);
    DWORD dwCurID = ::GetCurrentThreadId();
    ::AttachThreadInput(dwCurID,dwForeID,TRUE);
    ::SetForegroundWindow((HWND)effectiveWinId());
    ::SetWindowPos( (HWND)effectiveWinId(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
    showNormal();
    ::SetForegroundWindow((HWND)effectiveWinId());
    ::AttachThreadInput(dwCurID,dwForeID,FALSE);
    QWidget::show();
}

void Widget::paintEvent(QPaintEvent *)
{
    QStyleOption opt;
    opt.init(this);
    QPainter p(this);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);
}

void Widget::keyPressEvent(QKeyEvent *key)
{
    qDebug()<<key->key() <<" keyPressEvent()";
    if(key->key() == Qt::Key_Enter || key->key() == Qt::Key_Return)
    {
        qDebug()<<"Qt::Key_Enter or Qt::Key_Return";
        emit getCode(strCode);
        setVisible(false);
        return;
    }
    strCode.append(key->text());
}


//QString Widget::getCode(QString strCode)
//{
//    //strCode = ui->code->text();
//    qDebug()<<strCode;
//    ui->code->setText(QString());
//    QString str = QString("\nrecharge amount: %1\npay code: %2\n").arg(1).arg(strCode);
//    QMessageBox::information(this,"recharge confirm",str);
//    //ui->amountInput->setFocus();
//    QJsonObject rechargeObj;
//    rechargeObj.insert("pos_ver",2);
//    rechargeObj.insert("fm_cmd",10031);
//    rechargeObj.insert("trans_id",QString());
//    rechargeObj.insert("order_amount",0);
//    rechargeObj.insert("paid_amount",0);
//    rechargeObj.insert("undis_amount",0);
//    rechargeObj.insert("barcode",QString());
//    rechargeObj.insert("products",QJsonValue());
//    qDebug()<<rechargeObj;
//    return str;
//}

void Widget::close()
{
//    qDebug()<<"close button cliecked!";
//    qDebug()<<strCode;
//    QString text = ui->code->text();
//    OutputDebugString(text.toStdWString().c_str());
//    qDebug()<<"ui->code->text() "<<text;
//    emit getCode(strCode);
//    emit QWidget::close();

}

void Widget::animationFinished()
{
    scanningBar->setDuration(1500);
        if(animationUp)
        {
            scanningBar->setStartValue( QRect( 0,320,330,33));
            scanningBar->setEndValue( QRect( 0,400, 330,33));
        }
        else
        {
            scanningBar->setStartValue( QRect( 0,400, 330,33));
            scanningBar->setEndValue( QRect( 0,320,330,33));
        }
        animationUp = !animationUp;
        scanningBar->start();
}
