#include "widget.h"
#include "ui_widget.h"

#include <QPixmap>
#include <QPropertyAnimation>
#include <Windows.h>
#pragma comment(lib, "user32.lib")

Widget::Widget(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::Widget)
{
    ui->setupUi(this);
    this->setWindowFlags(Qt::FramelessWindowHint);
    this->setAttribute(Qt::WA_TranslucentBackground);

    animation = new QPropertyAnimation(ui->label_wait_time_11, "pos");

    animation->setStartValue(QPoint(0,1));
    animation->setDuration(1000);
    animation->setEndValue(QPoint(150,1));
    animation->start();
    QObject::connect(animation,SIGNAL(finished()),this,SLOT(move()));
}

Widget::~Widget()
{
    delete ui;
}

void Widget::move()
{
    if(ui->label_wait_time_11->pos().x() == 0)
    {
        animation->setStartValue(QPoint(0,1));
        animation->setDuration(1000);
        animation->setEndValue(QPoint(150,1));
        animation->start();
    }
    else
    {
        animation->setStartValue(QPoint(150,1));
        animation->setDuration(1000);
        animation->setEndValue(QPoint(0,1));
        animation->start();
    }
}

//void Widget::showTop()
//{
//    hide();
//    Qt::WindowFlags wf = windowFlags();
//    wf = wf | Qt::WindowStaysOnTopHint;
//    setWindowFlags(wf);
//    showNormal();
//    //show();
//}

void Widget::showTop()
{
    showNormal();
    HWND hForeWnd = ::GetForegroundWindow();
    DWORD dwForeID = ::GetWindowThreadProcessId(hForeWnd,NULL);
    DWORD dwCurID = ::GetCurrentThreadId();
    ::AttachThreadInput(dwCurID,dwForeID,TRUE);
    ::SetForegroundWindow((HWND)effectiveWinId());
    ::SetWindowPos( (HWND)effectiveWinId(), HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
    showNormal();
    ::SetForegroundWindow((HWND)effectiveWinId());
    ::AttachThreadInput(dwCurID,dwForeID,FALSE);
    QWidget::show();
}
