#include "widget.h"
#include <QApplication>
#include "qfmclient.h"
#include "app_single.h"
#include "log.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    if(!checkOnly())
    {
        OutputDebugString(L"FmclientUi running.");
        return 0;
    }
    InitLogger();
    QLOG_INFO()<<"start FmclientUi...";
    Widget w;
    QFmClient client;
    QObject::connect(&client,&QFmClient::HideUi, &w, &Widget::hide,Qt::QueuedConnection);
    QObject::connect(&client,&QFmClient::ShowUi, &w, &Widget::showTop,Qt::QueuedConnection);
    QObject::connect(&client,&QFmClient::finished, &a, &a.quit);
    client.start();
    return a.exec();
}
