#ifndef MAINFORM_H
#define MAINFORM_H

#include <QDialog>
#include <QTableWidget>
#include "alertForm.h"
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "pickForm.h"
#include "settingForm.h"
#include "detailForm.h"
#include "DTools/sysTray.h"
#include "padForm.h"
#include <QListWidget>
#include <QTimer>

namespace Ui {
class MainForm;
}

class MainForm : public QWidget
{
    Q_OBJECT

public:
    explicit MainForm(QWidget *parent = 0);
    ~MainForm();

    /* 功能:自定义的显示函数
     * 参数:NULL
     * 返回:NULL
     * */
    void MyShow();

private:
    Ui::MainForm *ui;
    // 时间定时器
    QTimer m_timeTimer;

    // 记录是否要显示自配送订单提示框
    bool m_bShowSelfDeli;

    // 记录上一次选中的表单和按钮
    QPushButton *m_prevBtn;
    QTableWidget *m_prevTable;

    // 所有的表
    QList<QTableWidget*> m_tableList;

    // 通知窗口
    AlertForm *m_alertForm;
    // 人员选择窗口
    PickForm *m_pickForm;
    // 设置窗口
    SettingForm *m_settingForm;
    // 订单详情窗口
    DetailForm *m_detailForm;
    // 数字键盘窗口
    PadForm *m_padForm;
    // 搜索结果窗口
    QListWidget *m_resultForm;

    // 当前选中的表
    QTableWidget *m_currentTable;

    // 置顶计数器
    int m_raiseIndex;


    // 托盘图标
    SysTray m_tray;

    /* 功能:还原按钮和表
     * 参数:NULL
     * 返回:NULL
     * */
    void _RevertBtnTable();
    /* 功能:控制Table的排序
     * 参数:[1]是否开启排序
     * 返回:NULL
     * */
    void _SetTablesSortEnable(bool bEnable);
    /* 功能:根据订单状态获取对应的Tab按钮
     * 参数:[1]订单状态
     * 返回:对应的Tab按钮
     * */
    QPushButton *_GetTabBtnByOrderStatus(int orderStatus);



signals:
    /* 功能:开启流程控制器
     * 参数:NULL
     * 返回:NULL
     * */
    void flowStart();
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:获取在班收银员
     * 参数:NULL
     * 返回:NULL
     * */
    void getOnDutyCashiers();
    /* 功能:通知悬浮窗显示
     * 参数:NULL
     * 返回:NULL
     * */
    void showFloatForm();
    /* 功能:通知悬浮窗开始提示
     * 参数:[1]提示类型 0新订单1退款申请
     * 返回:NULL
     * */
    void startRemind(int type);
    /* 功能:通知悬浮窗停止提示
     * 参数:NULL
     * 返回:NULL
     * */
    void stopRemind();
    /* 功能:获取订单详情
     * 参数:NULL
     * 返回:NULL
     * */
    void getOrderDetails(const QString& orderId);
    /* 功能:将搜索框字符传递给搜索结果窗口
     * 参数:[1]搜索框现存字符
     * 返回:NULL
     * */
    void onSerachTextChanged(const QString&);


private slots:
    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();
    /* 功能:设置当前时间
     * 参数:NULL
     * 返回:NULL
     * */
    void onSetCurrentTime();
    /* 功能:Tab页按钮点击对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainTabBtnClicked();
    /* 功能:Tab页按钮点击对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainProcBtnClicked();
    /* 功能:选择收银员按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnCashier_clicked();
    /* 功能:设置按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnSet_clicked();
    /* 功能:隐藏按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnHide_clicked();
    /* 功能:上翻按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnUp_clicked();
    /* 功能:下翻按钮对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainBtnDown_clicked();
    /* 功能:点击订单对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onMainTableItemClicked(QTableWidgetItem *item);
    /* 功能:点击搜索对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainEdtSearch_clicked();
    /* 功能:搜索框回车事件
     * 参数:NULL
     * 返回:NULL
     * */
    void on_mainEdtSearch_returnPressed();
    /* 功能:键盘数字点击处理
     * 参数:NULL
     * 返回:NULL
     * */
    void onNumClicked(const QString& num);
    /* 功能:键盘数字删除处理
     * 参数:NULL
     * 返回:NULL
     * */
    void onNumDelete();
    /* 功能:点击搜索结果订单对应动作
     * 参数:NULL
     * 返回:NULL
     * */
    void onSearchResultItemClicked(QListWidgetItem * item);

public slots:
    /* 功能:隐藏通知窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void onHideAlert();
    /* 功能:显示通知窗口
     * 参数:[1]窗口类型[2]显示信息
     * 返回:NULL
     * */
    void onShowAlert(AlertForm::Type type, const QString& msg);
    /* 功能:设置门店信息
     * 参数:[1]门店编号
     * 返回:NULL
     * */
    void onSetStoreInfo(const QString& storeId);
    /* 功能:设置门店营业状态
     * 参数:[1]营业状态
     * 返回:NULL
     * */
    void onSetOpeStatus(const QString& status);
    /* 功能:设置门店网络状态
     * 参数:[1]网络状态
     * 返回:NULL
     * */
    void onSetNetStatus(const QString& status);
    /* 功能:更改订单列表信息
     * 参数:[1]订单对象[2]旧订单的状态
     * 返回:NULL
     * */
    void onChangeOrderStatus(OrderObject *orderObject, int oldStatus);
    /* 功能:显示配送员选择窗口
     * 参数:[1]订单编号[2]配送员信息
     * 返回:NULL
     * */
    void onShowDeliverPickForm(const QString& orderId, const QList<DeliverObject>& delivers);
    /* 功能:显示收银员选择窗口
     * 参数:[1]收银员信息
     * 返回:NULL
     * */
    void onShowCashierPickForm(const QList<CashierObject>& cashiers);
    /* 功能:更新收银员信息
     * 参数:NULL
     * 返回:NULL
     * */
    void onUpdateCashier(const CashierObject& cashier);
    /* 功能:显示订单详情
     * 参数:NULL
     * 返回:NULL
     * */
    void onShowOrderDetails(OrderObject* orderObject);
    /* 功能:显示订单搜索结果
     * 参数:[1]订单搜索结果
     * 返回:NULL
     * */
    void onShowSearchOrderResult(const QStringList& orderIdList);
    void onshow();
};

#endif // MAINFORM_H
