#ifndef CONFIGMANGER_H
#define CONFIGMANGER_H

#include <QSettings>
#include <QUrl>
#include <QPoint>

class ConfigManger
{
public:
    // 数据库连接信息
    typedef struct
    {
        QString host;
        QString username;
        QString password;
        QString database;
    }SqlConnectInfo;

public:
    static ConfigManger& GetInstance();

    /* 功能:获取数据库连接信息
     * 参数:NULL
     * 返回:连接信息
     * */
    SqlConnectInfo GetSqlConnectInfo();
    /* 功能:设置数据库连接信息
     * 参数:连接信息
     * 返回:NULL
     * */
    void SetSqlConnectInfo(const SqlConnectInfo& info);
    /* 功能:读取服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QUrl GetServerUrl();
    /* 功能:读取服务器备用地址
     * 参数:NULL
     * 返回:服务器备用地址
     * */
    QUrl GetServerUrl1();
    /* 功能:读取打印机名称
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetPrinterName();
    /* 功能:设置打印机名称
     * 参数:打印机名称
     * 返回:NULL
     * */
    void SetPrinterName(const QString& printer);
    /* 功能:读取悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    QPoint GetFloatInitPostion();
    /* 功能:设置悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    void setFloatInitPostion(const QPoint& postion);
    /* 功能:获取悬浮窗闪烁间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetBlinkInterval();
    /* 功能:获取播放声音间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetSoundInterval();
    /* 功能:获取退款监听端口
     * 参数:NULL
     * 返回:监听端口
     * */
    int GetListenPort();
    QString getproxyIp();
    int getproxyProt();
    void setPrinterMode(const QString &mode);
    void setPrinterCom(const QString &com);

private:
    ConfigManger();
    ConfigManger(ConfigManger const&);
    ConfigManger& operator=(ConfigManger const&);

private:
    // 程序配置和用户配置
    QSettings *m_config;
    QSettings *m_userConfig;
    QSettings *m_fmps;
};

#endif // CONFIGMANGER_H
