#include "configManger.h"

#include <QApplication>
#include "preDefine.h"
#include "QsLog.h"

ConfigManger &ConfigManger::GetInstance()
{
    static ConfigManger cm;
    return cm;
}

ConfigManger::ConfigManger()
{
    QString appDir = QApplication::applicationDirPath();
    QString config = QString("%1/%2").arg(appDir).arg(CONFIG_NAME);
    QString userConfig = QString("%1/%2").arg(appDir).arg(USERCONFIG_NAME);
    QString fmpsConfig = QString("%1/%2").arg(appDir).arg("fmps.ini");
    m_config = new QSettings(config, QSettings::IniFormat);
    m_userConfig = new QSettings(userConfig, QSettings::IniFormat);
    m_fmps = new QSettings(fmpsConfig,QSettings::IniFormat);
    m_fmps->setIniCodec("GB2312");
}

ConfigManger::SqlConnectInfo ConfigManger::GetSqlConnectInfo()
{
    SqlConnectInfo info;
    info.host = m_userConfig->value(INI_HOST).toString();
    info.username = m_userConfig->value(INI_USERNAME).toString();
    info.password = m_userConfig->value(INI_PASSWORD).toString();
    info.database = m_userConfig->value(INI_DATABASE).toString();
    return info;
}

void ConfigManger::SetSqlConnectInfo(const ConfigManger::SqlConnectInfo &info)
{
    m_userConfig->setValue(INI_HOST, info.host);
    m_userConfig->setValue(INI_USERNAME, info.username);
    m_userConfig->setValue(INI_PASSWORD, info.password);
    m_userConfig->setValue(INI_DATABASE, info.database);
}

QUrl ConfigManger::GetServerUrl()
{
    return m_config->value(INI_SERVER).toUrl();
}

QUrl ConfigManger::GetServerUrl1()
{
    return m_config->value(INI_SERVER1).toUrl();
}

QString ConfigManger::GetPrinterName()
{
    return m_fmps->value(INI_PRINTERNAME).toString();
}

void ConfigManger::SetPrinterName(const QString &printer)
{
    m_fmps->setValue("DRIVER/driver", QString::fromLocal8Bit(printer.toLocal8Bit().data()));
}

QPoint ConfigManger::GetFloatInitPostion()
{
    return m_userConfig->value(INI_FLOATPOSTION, QPoint(20, 20)).toPoint();
}

void ConfigManger::setFloatInitPostion(const QPoint &postion)
{
    m_userConfig->setValue(INI_FLOATPOSTION, postion);
}

int ConfigManger::GetBlinkInterval()
{
    return m_userConfig->value(INI_BLINKINTERVAL).toFloat()*1000;
}

int ConfigManger::GetSoundInterval()
{
    return m_userConfig->value(INI_SOUNDINTERVAL).toFloat()*1000;
}

int ConfigManger::GetListenPort()
{
    return m_config->value(INI_LISTENPORT, 34953).toInt();
}

QString ConfigManger::getproxyIp()
{
    return m_userConfig->value("Proxy/Ip").toString();
}

int ConfigManger::getproxyProt()
{
    return m_userConfig->value("Proxy/Prot").toInt();
}

void ConfigManger::setPrinterMode(const QString &mode)
{
    m_fmps->setValue("TYPE/type",mode);
}

void ConfigManger::setPrinterCom(const QString &com)
{
    m_fmps->setValue("COMDEF/com",com);
}



