#ifndef FMPRINTER_H
#define FMPRINTER_H

#include "fmprinter_global.h"
#include "Model/orderObject.h"
#include "Model/productObject.h"
#include <QLibrary>

class FMPRINTERSHARED_EXPORT FmPrinter
{
public:
    static FmPrinter& GetInstance();

    /* 功能:打印订单
     * 参数:[1]物理打印机名[2]订单对象
     * 返回:true成功false失败
     * */
    bool DoPrint(QString printerName, OrderObject *pData);
    /* 功能:打印测试
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:true成功false失败
     * */
    bool TestPrint(QString printerName, QString data);
    void setStoreName(QString name);
    int printsize;

private:
    QString storename;
    FmPrinter();
    FmPrinter(FmPrinter const&);
    FmPrinter& operator=(FmPrinter const&);

    /* 功能:从订单对象获取打印数据
     * 参数:[1]订单对象
     * 返回:打印数据
     * */
    QString _GetPrintData(OrderObject* pData);
    /* 功能:打印数据
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:打印数据
     * */
    bool _RawDataToPrinter(QString printerName, QString data);
    /* 功能:将【分】转化为【元】
     * 参数:[1]分
     * 返回:元
     * */


    typedef bool ( *OpenPrinter)( void);
    typedef void ( *PrintText)( char str[]);
    typedef void ( *ClosePrinter)(void);
    typedef bool ( *LoadAddress)(void);
    typedef int  (*Total)(int);

    int total;
    QLibrary m_print_lib;
    bool m_b_load_sucfl;
    OpenPrinter f_OpenPrinter;
    PrintText f_PrintText;
    ClosePrinter f_ClosePrinter;
    LoadAddress f_LaodAddress;
    Total f_total;
    QString _Penny2Dollar(int penny);
};

#endif // FMPRINTER_H
