#include "drinkItem.h"
#include "ui_drinkItem.h"

DrinkItem::DrinkItem(const QString &name, const QString &mate, QWidget *parent) :
    QWidget(parent),
    ui(new Ui::DrinkItem)
{
    ui->setupUi(this);

    m_drinkName = name;
    m_drinkMate = mate;

    ui->drinkName->setText(name);
    ui->drinkMates->setText(mate);
}

DrinkItem::~DrinkItem()
{
    delete ui;
}

QString DrinkItem::DrinkName()
{
    return m_drinkName;
}

void DrinkItem::SetDrinkName(const QString &name)
{
    m_drinkName = name;
    ui->drinkName->setText(m_drinkName);
}

QString DrinkItem::DrinkMate()
{
    return m_drinkMate;
}

void DrinkItem::SetDrinkMate(const QString &mate)
{
    m_drinkMate = mate;
    ui->drinkMates->setText(m_drinkMate);
}
