#ifndef MATECHOOSER_H
#define MATECHOOSER_H

#include <QButtonGroup>
#include <QDialog>
#include "../QsLog/QsLog.h"
#include "Model/productObject.h"

namespace Ui {
class MateChooser;
}

class QTreeWidgetItem;

class MateChooser : public QDialog
{
    Q_OBJECT

public:
    explicit MateChooser(QWidget *parent = 0);
    ~MateChooser();

    void        setTitle(const QString &t);
    QString     getTitle() const;

    QList<ProductObject *>     candidates();
    void                    setMates(const QList<ProductObject *> &pendingMates,
                                     QList<ProductObject *> &assignedMates);
    QList<ProductObject *>     selectedMates() const;

public slots:
    void        on_mateCancel_clicked();
    void        on_mateConfirm_clicked();
    void        onMateItemClicked(QAbstractButton *item);

private:
    Ui::MateChooser *ui;
    QButtonGroup    _group;

    QList<ProductObject *>         _selected_mates;
    QMap<QString, ProductObject*>  _candidates_map;
};

#endif // MATECHOOSER_H
