/********************
 * 同意订单退款控制
 * *****************/
#ifndef REFUNDCONTROL_H
#define REFUNDCONTROL_H

#include <QObject>
#include <QTcpServer>
#include <QTcpSocket>
#include <QMutex>
#include "Network/billSocket.h"

class RefundControl : public QObject
{
public:
    static RefundControl& GetInstance();

    void SetListenPort(int port);

private:
    RefundControl(){}
    RefundControl(RefundControl const&);
    RefundControl& operator=(RefundControl const&);
    ~RefundControl();

    QTcpServer *m_tcpServer;
    QTcpSocket *m_tcpSocket;
    int m_port;
    bool m_bContinue;
    QMutex m_mutex;

    BillSocket *m_procOrderSocket;

public slots:
    /* 功能:开启控制器
     * 参数:NULL
     * 返回:NULL
     * */
    void run();
};

#endif // REFUNDCONTROL_H
