#include "mainForm.h"
#include "ui_mainForm.h"
#include <QTcpSocket>
#include <QDebug>

MainForm::MainForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::MainForm)
{
    ui->setupUi(this);
}

MainForm::~MainForm()
{
    delete ui;
}

void MainForm::on_btnSendData_clicked()
{
    QTcpSocket socket;
    socket.connectToHost(ui->host->text(), ui->port->text().toInt());

    if(socket.waitForConnected())
    {
        socket.write(ui->sendData->toPlainText().toLatin1());
        if(socket.waitForBytesWritten())
        {
            if(socket.waitForReadyRead())
            {
                ui->label->setText(QString(socket.readAll()));
            }
        }
    }
}
