#include "pickForm.h"
#include "ui_pickForm.h"
#include "preDefine.h"
#include "Control/flowControl.h"

PickForm::PickForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::PickForm)
{
    ui->setupUi(this);

    m_prevBtn = NULL;

    for(int i=0; i<10; i++)
    {
        QPushButton* btn = findChild<QPushButton*>(QString("pickBtn%1").arg(i));
        m_numBtnList.append(btn);
        connect(btn, &QPushButton::toggled, this, &PickForm::onNumBtnToggled);
    }
    connect(this, &PickForm::processOrder, &FlowControl::GetInstance(), &FlowControl::onProcessOrder);

    _Init();
}

PickForm::~PickForm()
{
    delete ui;
}

void PickForm::SetDeliversInfo(const QString &orderId, const QList<DeliverObject> &delivers)
{
    m_orderId = orderId;

    _InitBtn();

    int count = delivers.count()>10?10:delivers.count();
    for(int i=0; i<count; i++)
    {
        m_numBtnList[i]->setText(delivers[i].name);
        m_numBtnList[i]->setProperty(PROPERTY_ID, delivers[i].id);
        m_numBtnList[i]->setProperty(PROPERTY_NAME, delivers[i].name);
        m_numBtnList[i]->setProperty(PROPERTY_PHONE, delivers[i].phone);
        m_numBtnList[i]->setEnabled(true);
    }

    m_formType = 0;
}

void PickForm::SetCashiersInfo(const QList<CashierObject> &cashiers)
{
    _InitBtn();

    int count = cashiers.count()>10?10:cashiers.count();
    for(int i=0; i<count; i++)
    {
        m_numBtnList[i]->setText(cashiers[i].name);
        m_numBtnList[i]->setProperty(PROPERTY_ID, cashiers[i].id);
        m_numBtnList[i]->setProperty(PROPERTY_NAME, cashiers[i].name);
        m_numBtnList[i]->setProperty(PROPERTY_SHIFTID, cashiers[i].shiftId);
        m_numBtnList[i]->setProperty(PROPERTY_SHIFTNAME, cashiers[i].shiftName);
        m_numBtnList[i]->setEnabled(true);
    }

    m_formType = 1;
}

void PickForm::_Init()
{
    setWindowFlags(windowFlags()|Qt::FramelessWindowHint);
    setGeometry(((QWidget*)parent())->geometry());
    setAttribute(Qt::WA_TranslucentBackground);
    setModal(true);
}

void PickForm::_InitBtn()
{
    foreach(QPushButton* btn, m_numBtnList)
    {
        btn->setText("");
        btn->setChecked(false);
        btn->setEnabled(false);
    }
    ui->pickBtnOk->setEnabled(false);
}

void PickForm::onNumBtnToggled(bool bChecked)
{
    QPushButton *btn = (QPushButton*)sender();
    if(bChecked)
    {
        if(m_prevBtn != NULL && m_prevBtn != btn)
        {
            m_prevBtn->setChecked(false);
        }
        m_prevBtn = btn;
        if(m_formType == 0)
        {
            m_deliverObj.id = btn->property(PROPERTY_ID).toString();
            m_deliverObj.name = btn->property(PROPERTY_NAME).toString();
            m_deliverObj.phone = btn->property(PROPERTY_PHONE).toString();
        }else if(m_formType == 1)
        {
            m_cashierObj.id = btn->property(PROPERTY_ID).toString();
            m_cashierObj.name = btn->property(PROPERTY_NAME).toString();
            m_cashierObj.shiftId = btn->property(PROPERTY_SHIFTID).toString();
            m_cashierObj.shiftName = btn->property(PROPERTY_SHIFTNAME).toString();
        }
        ui->pickBtnOk->setEnabled(true);
    }else
    {
        ui->pickBtnOk->setEnabled(false);
    }
}

void PickForm::on_pickBtnOk_clicked()
{
    if(m_formType == 0)
    {
        emit processOrder(OPERATION_CONFRIM, m_orderId, m_deliverObj);
    }else if(m_formType == 1)
    {
        emit updateCashier(m_cashierObj);
    }
    hide();
}
