#include "floatForm.h"
#include "ui_floatForm.h"
#include <QPixmap>
#include "DTools/configManger.h"
#include "preDefine.h"
#include "QsLog.h"

FloatForm::FloatForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FloatForm)
{
    ui->setupUi(this);

    m_bReminding = false;

    QPixmap imgNormal(":float_normal.png");
    m_imgNormalSize = imgNormal.size();
    QPixmap imgRemind(":float_remind.png");
    m_imgRemindSize = imgRemind.size();

    m_animation.setTargetObject(this);
    m_animation.setPropertyName("windowOpacity");
    m_animation.setDuration(ConfigManger::GetInstance().GetBlinkInterval());
    m_animation.setEasingCurve(QEasingCurve::InOutSine);

    m_raiseTimer.setInterval(2000);
    connect(&m_raiseTimer, &QTimer::timeout, this, &FloatForm::raise);

    _Init();
}

FloatForm::~FloatForm()
{
    delete ui;
}

void FloatForm::mouseMoveEvent(QMouseEvent *event)
{
    if ((event->buttons()==Qt::LeftButton) && m_bMousePress)
    {
        QPoint moveAmount = event->globalPos() - m_lastMousePos;
        m_absMove += moveAmount;
        move(pos() + moveAmount);
        m_lastMousePos = event->globalPos();
        m_bMouseMove = true;
    }
}

void FloatForm::mousePressEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = true;
        m_lastMousePos = event->globalPos();
        m_absMove = QPoint(0,0);
    }
}

void FloatForm::mouseReleaseEvent(QMouseEvent *event)
{
    if (event->button()==Qt::LeftButton)
    {
        m_bMousePress = false;
    }
    int x = m_absMove.x();
    int y = m_absMove.y();
    if(!m_bMouseMove || (((x>-10)&&(x<10))&&((y>-10)&&(y<10))))
    {
        hide();
        m_raiseTimer.stop();
        emit showMainForm();
    }

    m_bMouseMove = false;
    ConfigManger::GetInstance().setFloatInitPostion(event->globalPos());
}

void FloatForm::_Init()
{
    setWindowFlags(this->windowFlags() | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint | Qt::Tool);
    setAttribute(Qt::WA_TranslucentBackground);

    setFixedSize(m_imgNormalSize);
    setStyleSheet("#floatWdg{ border-image: url(:float_normal.png); }");

    move(ConfigManger::GetInstance().GetFloatInitPostion());
}

void FloatForm::_Blink()
{
    QEventLoop loop;
    connect(&m_animation, &QPropertyAnimation::finished, &loop, &QEventLoop::quit);
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
    this->setFixedSize(m_imgRemindSize);
    ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_remind.png)}");
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();
    m_animation.setStartValue(1);
    m_animation.setEndValue(0);
    m_animation.start();
    loop.exec();
    this->setFixedSize(m_imgNormalSize);
    ui->floatWdg->setStyleSheet("#floatWdg{ border-image: url(:float_normal.png)}");
    m_animation.setStartValue(0);
    m_animation.setEndValue(1);
    m_animation.start();
    loop.exec();

    if(m_bReminding)
    {
        QTimer::singleShot(ConfigManger::GetInstance().GetBlinkInterval(), this, &FloatForm::_Blink);
    }
}

void FloatForm::_PlayWav()
{
    QSound::play(m_remindWav);

    if(m_bReminding)
    {
        QTimer::singleShot(m_wavPlayInterval, this, &FloatForm::_PlayWav);
    }
}

void FloatForm::onStartRemind(int type)
{
    switch(type)
    {
    case 0:
        m_remindWav = QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath());
        // 加上音频的时长
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_NEWORDERTIME;
        break;
    case 1:
        m_remindWav = QString("%1/wav/msg1.wav").arg(QApplication::applicationDirPath());
        m_wavPlayInterval = ConfigManger::GetInstance().GetSoundInterval() + VALUE_REFUNDORDERTIME;
        break;
    }
    if(m_bReminding)
    {
        return;
    }else
    {
       m_bReminding = true;
    }

    _Blink();
    _PlayWav();
}

void FloatForm::onStopRemind()
{
    m_bReminding = false;
}

void FloatForm::onShow()
{
    show();
    m_raiseTimer.start();
}
