#include "configManger.h"

#include <QApplication>
#include "preDefine.h"

ConfigManger &ConfigManger::GetInstance()
{
    static ConfigManger cm;
    return cm;
}

ConfigManger::ConfigManger()
{
    QString appDir = QApplication::applicationDirPath();
    QString config = QString("%1/%2").arg(appDir).arg(CONFIG_NAME);
    QString userConfig = QString("%1/%2").arg(appDir).arg(USERCONFIG_NAME);
    m_config = new QSettings(config, QSettings::IniFormat);
    m_userConfig = new QSettings(userConfig, QSettings::IniFormat);
}

ConfigManger::SqlConnectInfo ConfigManger::GetSqlConnectInfo()
{
    SqlConnectInfo info;
    info.host = m_userConfig->value(INI_HOST).toString();
    info.username = m_userConfig->value(INI_USERNAME).toString();
    info.password = m_userConfig->value(INI_PASSWORD).toString();
    info.database = m_userConfig->value(INI_DATABASE).toString();
    return info;
}

void ConfigManger::SetSqlConnectInfo(const ConfigManger::SqlConnectInfo &info)
{
    m_userConfig->setValue(INI_HOST, info.host);
    m_userConfig->setValue(INI_USERNAME, info.username);
    m_userConfig->setValue(INI_PASSWORD, info.password);
    m_userConfig->setValue(INI_DATABASE, info.database);
}

QUrl ConfigManger::GetServerUrl()
{
    return m_config->value(INI_SERVER).toUrl();
}

QString ConfigManger::GetPrinterName()
{
    return m_userConfig->value(INI_PRINTERNAME).toString();
}

void ConfigManger::SetPrinterName(const QString &printer)
{
    m_userConfig->setValue(INI_PRINTERNAME, printer);
}

QPoint ConfigManger::GetFloatInitPostion()
{
    return m_userConfig->value(INI_FLOATPOSTION, QPoint(20, 20)).toPoint();
}

void ConfigManger::setFloatInitPostion(const QPoint &postion)
{
    m_userConfig->setValue(INI_FLOATPOSTION, postion);
}

int ConfigManger::GetBlinkInterval()
{
    return m_userConfig->value(INI_BLINKINTERVAL).toFloat()*1000;
}

int ConfigManger::GetSoundInterval()
{
    return m_userConfig->value(INI_SOUNDINTERVAL).toFloat()*1000;
}

bool ConfigManger::GetIsExistReEntryOrder()
{
    return m_config->value(INI_REENTRY, 0).toBool();
}

int ConfigManger::GetTcpServerPort()
{
    return m_config->value(INI_TCPPORT, 93953).toInt();
}



