#ifndef SINFOCONTROL_H
#define SINFOCONTROL_H

#include <QObject>
#include <QTcpServer>
#include <QTcpSocket>

class SInfoControl : public QObject
{
    Q_OBJECT
public:
    static SInfoControl& GetInstance();

    void SetListenPort(int port);

private:
    SInfoControl(){}
    SInfoControl(SInfoControl const&);
    SInfoControl& operator=(SInfoControl const&);

    QTcpServer *m_tcpServer;
    QTcpSocket *m_tcpSocket;
    int m_port;

public slots:
    /* 功能:开启控制器
     * 参数:NULL
     * 返回:NULL
     * */
    void run();

signals:
    /* 功能:通知主界面监听失败
     * 参数:[1]失败信息
     * 返回:NULL
     * */
    void listenFailed(const QString& error);

    /* 功能:通知获取到门店信息
     * 参数:[1]操作员ID[2]POS机ID
     *      [3]门店ID[4]营业日
     * 返回:NULL
     * */
    void getNewStoreInfo(const QString& operator_id, const QString& pos_id,
                         const QString& store_id, const QString& business_date);
};

#endif // SINFOCONTROL_H
