#include "sinfoControl.h"
#include "QsLog.h"
#include <QJsonObject>
#include <QJsonDocument>

SInfoControl &SInfoControl::GetInstance()
{
    static SInfoControl sc;
    return sc;
}

void SInfoControl::SetListenPort(int port)
{
    m_port = port;
}

void SInfoControl::run()
{
    m_tcpServer = new QTcpServer(this);

    if(!m_tcpServer->listen(QHostAddress::LocalHost, m_port))
    {
        emit listenFailed(QString("绑定端口[%1]失败!").arg(m_port));
        QLOG_ERROR() << QString("SInfoControl listen failed on port[%1]").arg(m_port);
        return;
    }

    QByteArray recvData;
    QString replyData;
    QJsonParseError jsonError;
    QJsonDocument jsonDoc;
    while(true)
    {
        if(!m_tcpServer->waitForNewConnection(60000))
        {
            continue;
        }
        QLOG_INFO() << "onNewConnecion come.....";
        QString error;
        QString fm_cmd, fm_ver, operator_id, pos_id, store_id, business_date;
        QJsonObject store_info;
        m_tcpSocket = m_tcpServer->nextPendingConnection();
        if(!m_tcpSocket->waitForReadyRead())
        {
            m_tcpSocket->close();
            continue;
        }
        recvData = m_tcpSocket->readAll();
        QLOG_INFO() << QString("recv data.[%1]").arg(QString(recvData));

        jsonDoc = QJsonDocument::fromJson(recvData, &jsonError);
        if(jsonError.error == QJsonParseError::NoError)
        {
            QJsonObject jsonObject = jsonDoc.object();
            fm_cmd = jsonObject["fm_cmd"].toString();
            fm_ver = jsonObject["fm_ver"].toString();
            store_info = jsonObject["store_info"].toObject();
            operator_id = store_info["operator_id"].toString();
            pos_id = store_info["pos_id"].toString();
            store_id = store_info["store_id"].toString();
            business_date = store_info["business_date"].toString();
            if(!fm_cmd.compare("put_store_info"))
            {
                if(!fm_ver.compare("1.0"))
                {
                    if(!operator_id.isEmpty() && !pos_id.isEmpty()
                       && !store_id.isEmpty() && !business_date.isEmpty())
                    {
                        emit getNewStoreInfo(operator_id, pos_id, store_id, business_date);
                        replyData = QString("{\"statusCode\": 100,\"msg\": \"\"}");
                        m_tcpSocket->write(replyData.toUtf8());
                        m_tcpSocket->waitForBytesWritten();
                        m_tcpSocket->close();
                        continue;
                    }else
                    {
                        error = QString("wrong store_info");
                    }
                }else
                {
                    error = QString("wrong ver, current[%1] right[1.0]").arg(fm_ver);
                }
            }else
            {
                error = QString("wrong cmd, current[%1] right[put_store_info]").arg(fm_cmd);
            }
        }else
        {
            error = "invalid data";
        }

        // 发生错误
        replyData = QString("{\"statusCode\":0, \"msg\":\"%1\"}").arg(error);
        m_tcpSocket->write(replyData.toUtf8());
        m_tcpSocket->waitForBytesWritten();
        m_tcpSocket->close();
        continue;
    }
    QLOG_INFO() << "refundControl exit.";
}
