/********************
 * 流程控制
 * *****************/

#ifndef FLOWCONTROL_H
#define FLOWCONTROL_H

#include <QObject>
#include "Network/billSocket.h"
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "Model/cashierObject.h"
#include "alertForm.h"
#include <QMap>

class FlowControl : public QObject
{
    Q_OBJECT
public:
    static FlowControl& GetInstance();

private:
    FlowControl();
    FlowControl(FlowControl const&);
    FlowControl& operator=(FlowControl const&);

private:
    // 门店信息
    QString m_storeId;
    QString m_posId;
    QString m_cashierId;
    QDateTime m_bDate;
    // 网络通信
    BillSocket *m_loginSocket;
    BillSocket *m_pullOrderSocket;
    BillSocket *m_procOrderSocket;
    // 拉取订单的时间戳
    QString m_timestamp;
    // 订单容器
    QMap<QString, OrderObject*> m_ordersMap;
    // 是否第一次获取到门店信息
    bool m_bFirstRecvInfo;

signals:
    /* 功能:隐藏通知窗口
     * 参数:NULL
     * 返回:NULL
     * */
    void hideAlert();
    /* 功能:显示通知窗口
     * 参数:[1]窗口类型[2]显示信息
     * 返回:NULL
     * */
    void showAlert(AlertForm::Type type, const QString& msg);
    /* 功能:设置主界面门店信息
     * 参数:[1]门店号
     * 返回:NULL
     * */
    void setStoreInfo(const QString& storeId);
    /* 功能:设置主界收银员信息
     * 参数:[1]收银员信息
     * 返回:NULL
     * */
    void setCashierInfo(const QString& cashierInfo);
    /* 功能:设置门店营业状态
     * 参数:[1]营业状态
     * 返回:NULL
     * */
    void setOpeStatus(const QString& status);
    /* 功能:设置门店网络状态
     * 参数:[1]网络状态
     * 返回:NULL
     * */
    void setNetStatus(const QString& status);
    /* 功能:更改订单显示表
     * 参数:[1]订单对象[2]旧订单的状态
     * 返回:NULL
     * */
    void changeOrderStatus(OrderObject* orderObject, int oldStatus=-100);
    /* 功能:显示配送员选择窗
     * 参数:[1]订单编号[2]配送员信息
     * 返回:NULL
     * */
    void showDeliverPickForm(const QString& orderId, const QList<DeliverObject>& delivers);
    /* 功能:显示订单详情界面
     * 参数:[1]收银员信息
     * 返回:NULL
     * */
    void showOrderDetails(OrderObject* orderObject);
    /* 功能:显示订单搜索结果
     * 参数:[1]搜索结果
     * 返回:NULL
     * */
    void showSearchOrderResult(const QStringList& orderIdList);

private slots:
    /* 功能:登录
     * 参数:NULL
     * 返回:是否成功
     * */
    bool _Login();
    /* 功能:拉取订单
     * 参数:NULL
     * 返回:是否成功
     * */
    bool _PullOrder();
    /* 功能:获取配送员
     * 参数:[1]订单编号
     * 返回:是否成功
     * */
    bool _GetDelivers(const QString& orderId);
    /* 功能:确认订单
     * 参数:[1]订单编号[2]配送员信息
     * 返回:是否成功
     * */
    bool _ConfirmOrder(const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:拒绝订单
     * 参数:[1]订单编号[2]拒单原因
     * 返回:是否成功
     * */
    bool _RefuseOrder(const QString& orderId, int refuseCode);
    /* 功能:送出订单
     * 参数:[1]订单编号
     * 返回:是否成功
     * */
    bool _SendOrder(const QString& orderId);
    /* 功能:完成订单
     * 参数:NULL
     * 返回:是否成功
     * */
    bool _CompleteOrder(const QString& orderId);
    /* 功能:拒绝退单
     * 参数:NULL
     * 返回:是否成功
     * */
    bool _RefuseRefund(const QString& orderId);
    /* 功能:退单
     * 参数:NULL
     * 返回:是否成功
     * */
    bool _RefundOrder(const QString& orderId);
    /* 功能:获取Json对象的字符
     * 参数:NULL
     * 返回:Json字符串
     * */
    QString _GetJsonStr(const QJsonObject& json);

public slots:
    /* 功能:获取到新的门店信息
     * 参数:[1]操作员ID[2]POS机ID
     *      [3]门店ID[4]营业日
     * 返回:NULL
     * */
    void onGetNewStoreInfo(const QString& operator_id, const QString& pos_id,
                           const QString& store_id, const QString& business_date);
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员姓名
     * 返回:NULL
     * */
    void onProcessOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:获取订单详情
     * 参数:NULL
     * 返回:NULL
     * */
    void onGetOrderDetails(const QString& orderId);
    /* 功能:搜索订单
     * 参数:[1]搜索内容
     * 返回:NULL
     * */
    void onSerachOrder(const QString& text);
};

#endif // FLOWCONTROL_H
