#ifndef FMPLUGIN_H
#define FMPLUGIN_H

#include "fmplugin_global.h"
#include "Model/orderObject.h"
#include "Model/cashierObject.h"
#include <QtSql/QSqlDatabase>
#include <QDateTime>
#include <QThread>
#include <QTcpServer>

class PluginWorker;

class FMPLUGINSHARED_EXPORT FmPlugin
{
public:
    static FmPlugin& GetInstance();

    void SetRemoteInfo(const QString& ip, int port);

    /* 功能:写入销售单
     * 参数:[1]订单对象[2]错误信息[3]是否是确认动作
     * 返回:是否成功
     * */
    bool DoOrderEntry(OrderObject const *orderObject, QString& error, bool bVerify = false);
    /* 功能:撤销销售单
     * 参数:[1]订单编号[2]错误信息
     * 返回:是否成功
     * */
    bool RefundOrder(const QString& orderId, QString& error);

private:
    FmPlugin(){}
    FmPlugin(FmPlugin const&);
    FmPlugin& operator=(FmPlugin const&);

    // 通信地址
    QString m_host;
    int m_port;

    // 订单对象
    OrderObject const *m_orderObject;

    /* 功能:获取写入销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray _GetOrderEntryData(OrderObject const *orderObject, bool bVerify = false);
    /* 功能:获取写入销售单数据
     * 参数:[1]订单对象
     * 返回:写入销售单数据
     * */
    QByteArray _GetRefundOrderData(const QString& orderId);
};

#endif // FMPLUGIN_H
