#ifndef DATAMANGER_H
#define DATAMANGER_H

#include <QJsonObject>
#include <QJsonArray>
#include "Model/stockObject.h"

class DataManger
{
public:
    static DataManger& GetInstance();

    /* 功能:设置token信息
     * 参数:[1]token
     * 返回:NULL
     * */
    void SetToken(const QString& token);
    /* 功能:获取登录数据
     * 参数:[1]门店号[2]密码[3]收银机号[4]收银员号
     * 返回:登录数据
     * */
    QJsonObject GetLoginData(const QString& storeId, const QString& password,
                             const QString& stationId, const QString& cashierId);
    /* 功能:获取拉取订单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetPullOrderData(const QString& timestamp);
    /* 功能:获取拉取配送员数据
     * 参数:[1]门店号[2]渠道代码
     * 返回:登录数据
     * */
    QJsonObject GetPullDeliverData(const QString& storeId, const QString& channelCode);
    /* 功能:获取确认订单数据
     * 参数:[1]订单编号[2]配送员编号[3]配送员姓名[4]配送员电话
     * 返回:登录数据
     * */
    QJsonObject GetConfirmOrderData(const QString& orderId, const QString& deliverId,
                                    const QString& deliverName, const QString& deliverPhone);
    /* 功能:获取拒绝订单数据
     * 参数:[1]拒单原因[2]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetRefuseOrderData(int refuseCode, const QString& orderId);
    /* 功能:获取送出订单数据
     * 参数:[1]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetSendOrderData(const QString& orderId);
    /* 功能:获取完成订单数据
     * 参数:[1]订单编号
     * 返回:登录数据
     * */
    QJsonObject GetCompleteOrderData(const QString& orderId);
    /* 功能:获取同意退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefundOrderData(const QString& reason, const QString& orderId);
    /* 功能:获取拒绝退单数据
     * 参数:[1]时间戳
     * 返回:登录数据
     * */
    QJsonObject GetRefuseRefundData(const QString& reason, const QString& orderId);
    /* 功能:获取同步库存数据
     * 参数:[1]库存信息
     * 返回:同步库存数据
     * */
    QJsonObject GetSynStockData(const QList<StockObject>& stockList);

private:
    DataManger(){}
    DataManger(DataManger const&);
    DataManger& operator=(DataManger const&);
    // token
    QString m_token;
};

#endif // DATAMANGER_H
