#include "settingForm.h"
#include "ui_settingForm.h"
#include "preDefine.h"
#include "DTools/configManger.h"
#include <QPrinterInfo>
#include <QSound>
#include "fmPrinter.h"
#include <QListView>

SettingForm::SettingForm(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingForm)
{
    ui->setupUi(this);
    // 初始化打印机选项
    QString printer = ConfigManger::GetInstance().GetPrinterName();
    QStringList printerList = QPrinterInfo::availablePrinterNames();
    for(int i=0; i<printerList.count(); i++)
    {
        QString name = printerList[i];
        ui->settingCbxPrinter->addItem(name);
        if(!name.compare(printer))
        {
            ui->settingCbxPrinter->setCurrentIndex(i);
        }
    }
    ui->settingCbxPrinter->addItem("默认");
//    ui->settingCbxPrinter->addItem("COM1");
//    ui->settingCbxPrinter->addItem("COM2");
//    ui->settingCbxPrinter->addItem("COM3");
//    ui->settingCbxPrinter->addItem("COM4");
    _Init();
    ui->settingCbxPrinter->setView(new QListView());
}

SettingForm::~SettingForm()
{
    delete ui;
}

void SettingForm::_Init()
{
    setWindowFlags(windowFlags() | Qt::FramelessWindowHint);
    setAttribute(Qt::WA_TranslucentBackground);
    setModal(true);
}

void SettingForm::on_settingCbxPrinter_activated(const QString &text)
{
    if(!text.compare("默认"))
    {
        ConfigManger::GetInstance().setPrinterMode("1");
    }
    else if(!text.compare("COM1"))
    {
        ConfigManger::GetInstance().setPrinterMode("0");
        ConfigManger::GetInstance().setPrinterCom("COM1");
    }
    else if(!text.compare("COM2"))
    {
        ConfigManger::GetInstance().setPrinterMode("0");
        ConfigManger::GetInstance().setPrinterCom("COM2");
    }
    else if(!text.compare("COM3"))
    {
        ConfigManger::GetInstance().setPrinterMode("0");
        ConfigManger::GetInstance().setPrinterCom("COM3");
    }
    else if(!text.compare("COM4"))
    {
        ConfigManger::GetInstance().setPrinterMode("0");
        ConfigManger::GetInstance().setPrinterCom("COM4");
    }
    else{
        ConfigManger::GetInstance().setPrinterMode("4");
        ConfigManger::GetInstance().SetPrinterName(text);
    }
}

void SettingForm::on_settingBtnPrintTest_clicked()
{
    QString testStr("这是一个测试页看到此此页说明打印正常!\r\n\r\n\r\n");
    FmPrinter::GetInstance().TestPrint(ConfigManger::GetInstance().GetPrinterName(), testStr);
}

void SettingForm::on_settingBtnSoundTest_clicked()
{
    QSound::play(QString("%1/wav/msg.wav").arg(QApplication::applicationDirPath()));
}
