#ifndef FMPLUGIN_H
#define FMPLUGIN_H

#include "fmplugin_global.h"
#include "Model/orderObject.h"
#include "Model/cashierObject.h"
#include "Model/stockObject.h"
#include <QtSql/QSqlDatabase>
#include <QDateTime>

class PluginWorker;

class FMPLUGINSHARED_EXPORT FmPlugin
{
public slots:
    static FmPlugin& GetInstance();

    /* 功能:连接数据库
     * 参数:[1]IP[2]用户名[3]密码[4]库名[5]错误
     * 返回:是否成功
     * */
    bool ConnectDb(const QString& host, const QString& username, const QString& password,
                   const QString& dbname, QString& error);
    /* 功能:获取门店信息
     * 参数:[1]门店编号[2]收银机编号[3]收银员编号[4]营业日[5]错误
     * 返回:是否成功
     * */
    bool GetStoreInfo(QString& storeId, QString& posId, QString& cashierId,
                      QDateTime& dateTime, QString& error);
    /* 功能:获取在班收银员信息
     * 参数:[1]收银员列表[2]错误信息
     * 返回:是否成功
     * */
    bool GetOnDutyCashiers(QList<CashierObject>& cashiersList, QString& error);
    /* 功能:写入销售单
     * 参数:[1]订单对象[2]错误信息
     * 返回:是否成功
     * */
    bool DoOrderEntry(OrderObject const *orderObject, const QString& cashierId, const QString& cashierName,
                      const QString& shiftId, const QString& shiftName, QString& error);
    /* 功能:获取库存信息
     * 参数:[1]_out库存信息
     * 返回:是否成功
     * */
    bool GetStockInfo(QList<StockObject>& stockList, QString& error);

private:
    FmPlugin()
    {
        m_recCodeMap.insert("mtwm", "9556000001");
        m_recCodeMap.insert("eleme", "9556000002");
        m_recCodeMap.insert("bdwm", "9556000003");
        m_recCodeMap.insert("jdwm", "9556000004");
    }
    FmPlugin(FmPlugin const&);
    FmPlugin& operator=(FmPlugin const&);

    // 数据库对象
    QSqlDatabase m_db;
    // 门店号
    QString m_storeId;
    // 订单对象
    const OrderObject *m_orderObject;
    // 错误信息
    QString m_lastError;

    // 各平台对应的receiverCode
    QMap<QString, QString> m_recCodeMap;

    /* 功能:写入表p_t_fmwm_custinfo(顾客信息表)
     * 参数:[1]_out信息ID
     * 返回:true成功false失败
     * */
    bool _InsertInto_p_t_fmwm_custinfo(int &custid);
    /* 功能:写入表d_t_food_fmbill0(销售主表)
     * 参数:[1]收银员ID[2]收银员姓名[3]班次ID[4]班次名称[5]顾客信息ID
     * 返回:true成功false失败
     * */
    bool _InsertInto_d_t_food_fmbill0(const QString& cashierId, const QString& cashierName,
                                      const QString& shiftId, const QString& shiftName, int custid);
    /* 功能:写入表d_t_food_fmbills0(销售明细表)
     * 参数:NULL
     * 返回:true成功false失败
     * */
    bool _InsertInto_d_t_food_fmbills0();
    /* 功能:写入表d_t_food_fmpay0(支付表)
     * 参数:NULL
     * 返回:true成功false失败
     * */
    bool _InsertInto_d_t_bill_fmpay0();
    /* 功能:执行存储过程pr_fmwm
     * 参数:NULL
     * 返回:true成功false失败
     * */
    bool _Exec_pr_fmwm();
    /* 功能:将【分】转化为【元】
     * 参数:[1]分
     * 返回:元
     * */
    double _Penny2Dollar(int penny);
    /* 功能:获取写销售单的数据
     * 参数:[1]订单对象
     * 返回:销售单数据
     * */
    QByteArray _GetOrderEntryData(const OrderObject*);
};

#endif // FMPLUGIN_H
