#ifndef REFUSEFORM_H
#define REFUSEFORM_H

#include <QDialog>
#include <QMap>

namespace Ui {
class RefuseForm;
}

class RefuseForm : public QDialog
{
    Q_OBJECT

public:
    explicit RefuseForm(QWidget *parent = 0);
    ~RefuseForm();
    /* 功能:设置窗口信息
     * 参数:[1]原因列表 [2]订单ID [3]操作名称
     * 返回:NULL
     * */
    void SetFormInfo(QStringList reasons, QString orderId, QString operation);

private slots:
    /* 功能:取消按钮对应的操作
     * 参数:NULL
     * 返回:NULL
     * */
    void on_refuseBtnCancle_clicked();
    /* 功能:确定按钮对应的操作
     * 参数:[bEnable]是否启用
     * 返回:NULL
     * */
    void on_refuseBtnOk_clicked();

private:
    Ui::RefuseForm *ui;

    QString m_orderId;
    QString m_operation;
    QMap<QString, QString> m_reasonCode;
};

#endif // REFUSEFORM_H
