#ifndef DETAILFORM_H
#define DETAILFORM_H

#include <QDialog>
#include <QTableWidget>
#include "Model/orderObject.h"
#include "Model/deliverObject.h"
#include "refuseForm.h"

namespace Ui {
class DetailForm;
}

class DetailForm : public QDialog
{
    Q_OBJECT

public:
    explicit DetailForm(QWidget *parent = 0);
    ~DetailForm();

    /* 功能:初始化数据
     * 参数:[1]订单对象
     * 返回:NULL
     * */
    void InitData(OrderObject* orderObject);

private:
    Ui::DetailForm *ui;

    OrderObject *m_orderObject;

    /* 功能:初始化
     * 参数:NULL
     * 返回:NULL
     * */
    void _Init();

signals:
    /* 功能:处理订单
     * 参数:[1]操作动作名[2]订单编号[3]配送员信息
     * 返回:NULL
     * */
    void processOrder(const QString& operation, const QString& orderId, const DeliverObject& deliverObj);
    /* 功能:补录订单
     * 参数:[1]订单编号
     * 返回:NULL
     * */
    void reEntryOrder(const QString& orderId);

private slots:
    /* 功能:处理订单按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void onOperaBtnClicked();
    /* 功能:处理重新录单按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn0_clicked();
    /* 功能:处理重新打印按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn1_clicked();
    /* 功能:处理拒绝按钮点击
     * 参数:NULL
     * 返回:NULL
     * */
    void on_detailBtn2_clicked();
};

#endif // DETAILFORM_H
