#ifndef DBSETFORM_H
#define DBSETFORM_H

#include <QDialog>

namespace Ui {
class DbsetForm;
}

class DbsetForm : public QDialog
{
    Q_OBJECT

public:
    explicit DbsetForm(QWidget *parent = 0);
    ~DbsetForm();

private:
    Ui::DbsetForm *ui;

    void _Init();

    /* 功能:设置子控件启用状态
     * 参数:[bEnable]是否启用
     * 返回:NULL
     * */
    void _SetSubElementEnable(bool bEnable);

signals:
    void connectDb(const QString& host, const QString& username,
                   const QString& password, const QString& dbname);

private slots:
    void on_dbsetBtnOk_clicked();
    void on_dbsetBtnCancle_clicked();

public slots:
    void onConnectDbFinsh(bool bSuccess, const QString& error);
};

#endif // DBSETFORM_H
