#ifndef FMPRINTER_H
#define FMPRINTER_H

#include "fmprinter_global.h"
#include "Model/orderObject.h"
#include "Model/productObject.h"

class FMPRINTERSHARED_EXPORT FmPrinter
{
public:
    static FmPrinter& GetInstance();

    /* 功能:打印订单
     * 参数:[1]物理打印机名[2]订单对象
     * 返回:true成功false失败
     * */
    bool DoPrint(QString printerName, OrderObject *pData);
    /* 功能:打印测试
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:true成功false失败
     * */
    bool TestPrint(QString printerName, QString data);

private:
    FmPrinter(){}
    FmPrinter(FmPrinter const&);
    FmPrinter& operator=(FmPrinter const&);

    /* 功能:从订单对象获取打印数据
     * 参数:[1]订单对象
     * 返回:打印数据
     * */
    QString _GetPrintData(OrderObject* pData);
    /* 功能:打印数据
     * 参数:[1]物理打印机名[2]信息内容
     * 返回:打印数据
     * */
    bool _RawDataToPrinter(QString printerName, QString data);
    /* 功能:将【分】转化为【元】
     * 参数:[1]分
     * 返回:元
     * */
    QString _Penny2Dollar(int penny);
};

#endif // FMPRINTER_H
