package com.freemud.framework.versionctl.proxy;



import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.freemud.framework.versionctl.VersionException;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: VersionBeanProxy
 * @Package com.freemud.framework.versionctl
 * @Description:
 * @author: dingshaocheng
 * @date: 2018/4/22
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Component
public class VersionBeanProxy implements InvocationHandler {
    private HashMap<String,Object> lstImpls = new HashMap<>();
    @Autowired
    private DefaultVersionBeanFactory defaultVersionBeanFactory;

    public Object getInstance(HashMap<String,Object> targets,Class<?> interfaceType){
        this.lstImpls = targets;
        Class<?>[] classes = new Class[1];
        classes[0] = interfaceType;
        //todo: 校验是否都实现了interfaceType
        targets.forEach((t,o)->{
            if(!interfaceType.isAssignableFrom(o.getClass())){
                throw new VersionException("没有实现接口");
            }
        });
        Object obj = Proxy.newProxyInstance(interfaceType.getClassLoader(), classes, this);
        return obj;
    }


    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String version = LocalVersionVariable.getVersion();
        //todo: 默认实现优化
        Object target = lstImpls.getOrDefault(version,defaultVersionBeanFactory.getDefaultBean(lstImpls));

        return method.invoke(target,args);
    }
}
