package com.freemud.framework.versionctl.boot;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.freemud.framework.versionctl.proxy.LocalVersionVariable;
import com.freemud.framework.versionctl.proxy.VersionGetter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: VersionCtlInvocationHandler
 * @Package com.freemud.framework.versionctl.boot
 * @Description:
 * @author: dingshaocheng
 * @date: 2018/4/22
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Component
public class VersionCtlInvocationHandler implements HandlerInterceptor {
    @Autowired
    private VersionGetter versionGetter;
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        LocalVersionVariable.setVersion(versionGetter.getVersion(request));
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LocalVersionVariable.clear();
    }
}
