package com.freemud.framework.boot;

import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

import com.freemud.framework.caching.ICacheManager;
import com.freemud.framework.caching.memory.MemoryCacheManager;
import com.freemud.framework.caching.memory.MemoryCacheOptions;

/**
 * @author dingshaocheng
 */
@AutoConfigureOrder
@ConditionalOnMissingBean(ICacheManager.class)
@EnableConfigurationProperties(MemoryCacheOptions.class)
public class MemoryCacheAutoLoad {

    @Bean
    public ICacheManager memoryCacheManager(){
        return new MemoryCacheManager();
    }
}
